/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;

public class StringListDeserializer
extends JsonDeserializer<List<String>> {
    @Override
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (p.getCurrentName().equalsIgnoreCase("aliases")) {
            return this.deserializeList(node, "alias");
        }
        if (p.getCurrentName().equalsIgnoreCase("tags")) {
            return this.deserializeList(node, "tag");
        }
        if (p.getCurrentName().equalsIgnoreCase("endpoints")) {
            return this.deserializeList(node, "endpoint");
        }
        if (p.getCurrentName().equalsIgnoreCase("altIds")) {
            return this.deserializeList(node, "altId");
        }
        return null;
    }

    private List<String> deserializeList(JsonNode node, String itemName) {
        ArrayList<String> list = new ArrayList<String>();
        if (node.has(itemName)) {
            node = node.get(itemName);
        }
        if (node != null) {
            if (node.isArray()) {
                for (JsonNode nodeObject : node) {
                    list.add(nodeObject.asText());
                }
            } else {
                list.add(node.asText());
            }
        }
        return list;
    }
}

