/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.Property;
import zz.org.cyclonedx.util.deserializer.PropertyDeserializer;

public class PropertiesDeserializer
extends JsonDeserializer<List<Property>> {
    private final PropertyDeserializer propertyDeserializer = new PropertyDeserializer();

    @Override
    public List<Property> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("property")) {
            return this.parseProperties(node.get("property"), p, ctxt);
        }
        return this.parseProperties(node, p, ctxt);
    }

    private List<Property> parseProperties(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayNode nodes = node.isArray() ? (ArrayNode)node : new ArrayNode(null).add(node);
        for (JsonNode resolvesNode : nodes) {
            Property type = this.parseProperty(resolvesNode, p, ctxt);
            properties.add(type);
        }
        return properties;
    }

    private Property parseProperty(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonParser propertyParser = node.traverse(p.getCodec());
        propertyParser.nextToken();
        return this.propertyDeserializer.deserialize(propertyParser, ctxt);
    }
}

