/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.TreeNode;
import zz.com.fasterxml.jackson.core.type.TypeReference;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.AttachmentText;
import zz.org.cyclonedx.model.Property;
import zz.org.cyclonedx.model.formulation.common.EnvVariableChoice;
import zz.org.cyclonedx.model.formulation.common.OutputType;
import zz.org.cyclonedx.model.formulation.common.ResourceReferenceChoice;

public class OutputTypeDeserializer
extends JsonDeserializer<OutputType> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public OutputType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        OutputType outputType = new OutputType();
        if (node.has("source")) {
            JsonNode sourceNode = node.get("source");
            ResourceReferenceChoice source = this.objectMapper.treeToValue((TreeNode)sourceNode, ResourceReferenceChoice.class);
            outputType.setSource(source);
        }
        if (node.has("target")) {
            JsonNode targetNode = node.get("target");
            ResourceReferenceChoice target = this.objectMapper.treeToValue((TreeNode)targetNode, ResourceReferenceChoice.class);
            outputType.setTarget(target);
        }
        this.createOutputDataInfo(node, outputType);
        if (node.has("properties")) {
            JsonNode propertiesNode = node.get("properties");
            List<Property> properties = this.objectMapper.convertValue((Object)propertiesNode, new TypeReference<List<Property>>(){});
            outputType.setProperties(properties);
        }
        if (node.has("type")) {
            JsonNode typeNode = node.get("type");
            OutputType.OutputTypeEnum type = this.objectMapper.treeToValue((TreeNode)typeNode, OutputType.OutputTypeEnum.class);
            outputType.setType(type);
        }
        return outputType;
    }

    private void createOutputDataInfo(JsonNode node, OutputType outputType) throws JsonProcessingException {
        if (node.has("resource")) {
            JsonNode resourceNode = node.get("resource");
            ResourceReferenceChoice resource = this.objectMapper.treeToValue((TreeNode)resourceNode, ResourceReferenceChoice.class);
            outputType.setResource(resource);
        } else if (node.has("environmentVars")) {
            JsonNode nodes = node.get("environmentVars");
            ArrayList<EnvVariableChoice> environmentVars = new ArrayList<EnvVariableChoice>();
            ArrayNode environmentVarsNode = nodes.isArray() ? (ArrayNode)nodes : new ArrayNode(null).add(nodes);
            for (JsonNode envVarNode : environmentVarsNode) {
                EnvVariableChoice envVar = this.objectMapper.treeToValue((TreeNode)envVarNode, EnvVariableChoice.class);
                environmentVars.add(envVar);
            }
            outputType.setEnvironmentVars(environmentVars);
        } else if (node.has("data")) {
            JsonNode dataNode = node.get("data");
            AttachmentText data = this.objectMapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            outputType.setData(data);
        }
    }
}

