/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.ObjectCodec;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.org.cyclonedx.model.OrganizationalContact;
import zz.org.cyclonedx.model.OrganizationalEntity;
import zz.org.cyclonedx.util.deserializer.MetadataDeserializer;

public class OrganizationalEntityDeserializer
extends JsonDeserializer<OrganizationalEntity> {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public OrganizationalEntity deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = jsonParser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jsonParser);
        String bomRef = node.has("bom-ref") ? node.get("bom-ref").asText() : null;
        String name = node.has("name") ? node.get("name").asText() : null;
        ArrayList<String> url = new ArrayList<String>();
        if (node.has("url")) {
            JsonNode urlNode = node.get("url");
            if (urlNode.isArray()) {
                for (JsonNode urlElement : urlNode) {
                    url.add(urlElement.asText());
                }
            } else if (urlNode.isTextual()) {
                url.add(urlNode.asText());
            }
        }
        OrganizationalEntity entity = new OrganizationalEntity();
        entity.setBomRef(bomRef);
        entity.setName(name);
        entity.setUrls(url);
        JsonNode contactNode = node.get("contact");
        if (contactNode != null) {
            List<OrganizationalContact> contacts = MetadataDeserializer.deserializerOrganizationalContact(contactNode, this.mapper);
            entity.setContacts(contacts);
        }
        return entity;
    }
}

