/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.org.cyclonedx.model.OrganizationalChoice;
import zz.org.cyclonedx.model.OrganizationalContact;
import zz.org.cyclonedx.model.OrganizationalEntity;

public class OrganizationalChoiceDeserializer
extends JsonDeserializer<OrganizationalChoice> {
    @Override
    public OrganizationalChoice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        OrganizationalChoice organizationalChoice = new OrganizationalChoice();
        if (node.has("individual")) {
            OrganizationalContact individual = jp.getCodec().treeToValue(node.get("individual"), OrganizationalContact.class);
            organizationalChoice.setIndividual(individual);
        } else if (node.has("organization")) {
            JsonNode organizationNode = node.get("organization");
            OrganizationalEntity organization = new OrganizationalEntity();
            organization.setName(organizationNode.get("name").asText());
            if (organizationNode.has("contact")) {
                JsonNode contactsNode = organizationNode.get("contact");
                if (contactsNode instanceof ArrayNode) {
                    for (JsonNode contactNode : contactsNode) {
                        OrganizationalContact contact = jp.getCodec().treeToValue(contactNode, OrganizationalContact.class);
                        organization.addContact(contact);
                    }
                } else if (contactsNode instanceof ObjectNode) {
                    OrganizationalContact contact = jp.getCodec().treeToValue(contactsNode, OrganizationalContact.class);
                    organization.addContact(contact);
                }
            }
            organizationalChoice.setOrganization(organization);
        }
        return organizationalChoice;
    }
}

