/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.core.TreeNode;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.AttachmentText;
import zz.org.cyclonedx.model.ReleaseNotes;

public class NotesDeserializer
extends JsonDeserializer<List<ReleaseNotes.Notes>> {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public List<ReleaseNotes.Notes> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.has("note")) {
            return this.parseNode(node.get("note"));
        }
        return this.parseNode(node);
    }

    private List<ReleaseNotes.Notes> parseNode(JsonNode node) throws JsonProcessingException {
        ArrayList<ReleaseNotes.Notes> list = new ArrayList<ReleaseNotes.Notes>();
        ArrayNode nodes = node.isArray() ? (ArrayNode)node : new ArrayNode(null).add(node);
        for (JsonNode noteNode : nodes) {
            ReleaseNotes.Notes notes = this.parseNotes(noteNode);
            list.add(notes);
        }
        return list;
    }

    private ReleaseNotes.Notes parseNotes(JsonNode node) throws JsonProcessingException {
        ReleaseNotes.Notes notes = new ReleaseNotes.Notes();
        if (node.has("locale")) {
            notes.setLocale(node.get("locale").asText());
        }
        if (node.has("text")) {
            JsonNode dataNode = node.get("text");
            AttachmentText data = this.mapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            notes.setText(data);
        }
        return notes;
    }
}

