/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.core.type.TypeReference;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.org.cyclonedx.model.Component;
import zz.org.cyclonedx.model.LicenseChoice;
import zz.org.cyclonedx.model.Lifecycles;
import zz.org.cyclonedx.model.Metadata;
import zz.org.cyclonedx.model.OrganizationalContact;
import zz.org.cyclonedx.model.OrganizationalEntity;
import zz.org.cyclonedx.model.Property;
import zz.org.cyclonedx.model.Service;
import zz.org.cyclonedx.model.Tool;
import zz.org.cyclonedx.model.metadata.ToolInformation;
import zz.org.cyclonedx.util.deserializer.LifecycleDeserializer;
import zz.org.cyclonedx.util.deserializer.PropertiesDeserializer;

public class MetadataDeserializer
extends JsonDeserializer<Metadata> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private final LifecycleDeserializer lifecycleDeserializer = new LifecycleDeserializer();
    private final PropertiesDeserializer propertiesDeserializer = new PropertiesDeserializer();

    @Override
    public Metadata deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode toolsNode;
        JsonNode timestampNode;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Metadata metadata = new Metadata();
        if (node.has("authors")) {
            JsonNode authorsNode = node.get("authors");
            List<OrganizationalContact> authors = MetadataDeserializer.deserializerOrganizationalContact(authorsNode, this.mapper);
            metadata.setAuthors(authors);
        }
        if (node.has("component")) {
            Component component = this.mapper.convertValue((Object)node.get("component"), Component.class);
            metadata.setComponent(component);
        }
        if (node.has("manufacture")) {
            OrganizationalEntity manufacture = this.mapper.convertValue((Object)node.get("manufacture"), OrganizationalEntity.class);
            metadata.setManufacture(manufacture);
        }
        if (node.has("lifecycles")) {
            JsonParser lifecycleParser = node.get("lifecycles").traverse(jsonParser.getCodec());
            lifecycleParser.nextToken();
            Lifecycles lifecycles = this.lifecycleDeserializer.deserialize(lifecycleParser, ctxt);
            metadata.setLifecycles(lifecycles);
        }
        if (node.has("supplier")) {
            OrganizationalEntity supplier = this.mapper.convertValue((Object)node.get("supplier"), OrganizationalEntity.class);
            metadata.setSupplier(supplier);
        }
        if (node.has("licenses")) {
            LicenseChoice license = this.mapper.convertValue((Object)node.get("licenses"), LicenseChoice.class);
            metadata.setLicenseChoice(license);
        }
        if (node.has("timestamp") && (timestampNode = node.get("timestamp")) != null && timestampNode.isTextual()) {
            String timestampStr = timestampNode.textValue();
            try {
                Date timestamp = this.dateFormat.parse(timestampStr);
                metadata.setTimestamp(timestamp);
            }
            catch (ParseException timestamp) {
                // empty catch block
            }
        }
        if (node.has("properties")) {
            JsonParser propertiesParser = node.get("properties").traverse(jsonParser.getCodec());
            propertiesParser.nextToken();
            Object properties = this.propertiesDeserializer.deserialize(propertiesParser, ctxt);
            metadata.setProperties((List<Property>)properties);
        }
        if ((toolsNode = node.get("tools")) != null) {
            if (toolsNode.isArray()) {
                List<Tool> tools = this.mapper.convertValue((Object)toolsNode, new TypeReference<List<Tool>>(){});
                metadata.setTools(tools);
            } else if (toolsNode.has("tool")) {
                JsonNode toolNode = toolsNode.get("tool");
                if (toolNode.isArray()) {
                    List<Tool> tools = this.mapper.convertValue((Object)toolsNode.get("tool"), new TypeReference<List<Tool>>(){});
                    metadata.setTools(tools);
                } else {
                    Tool tool = this.mapper.convertValue((Object)toolsNode.get("tool"), Tool.class);
                    metadata.setTools(Collections.singletonList(tool));
                }
            } else {
                ToolInformation toolInformation = new ToolInformation();
                if (toolsNode.has("components")) {
                    this.parseComponents(toolsNode.get("components"), toolInformation);
                }
                if (toolsNode.has("services")) {
                    this.parseServices(toolsNode.get("services"), toolInformation);
                }
                metadata.setToolChoice(toolInformation);
            }
        }
        return metadata;
    }

    private void parseComponents(JsonNode componentsNode, ToolInformation toolInformation) {
        if (componentsNode != null) {
            if (componentsNode.isArray()) {
                List<Component> components = this.mapper.convertValue((Object)componentsNode, new TypeReference<List<Component>>(){});
                toolInformation.setComponents(components);
            } else if (componentsNode.isObject()) {
                Component component = this.mapper.convertValue((Object)componentsNode, Component.class);
                toolInformation.setComponents(Collections.singletonList(component));
            }
        }
    }

    private void parseServices(JsonNode servicesNode, ToolInformation toolInformation) {
        if (servicesNode != null) {
            if (servicesNode.isArray()) {
                List<Service> services = this.mapper.convertValue((Object)servicesNode, new TypeReference<List<Service>>(){});
                toolInformation.setServices(services);
            } else if (servicesNode.isObject()) {
                Service service = this.mapper.convertValue((Object)servicesNode, Service.class);
                toolInformation.setServices(Collections.singletonList(service));
            }
        }
    }

    static List<OrganizationalContact> deserializerOrganizationalContact(JsonNode node, ObjectMapper mapper) {
        ArrayList<OrganizationalContact> organizationalContactList = new ArrayList<OrganizationalContact>();
        if (node.has("author")) {
            node = node.get("author");
        }
        if (node.isArray()) {
            for (JsonNode authorNode : node) {
                OrganizationalContact author = mapper.convertValue((Object)authorNode, OrganizationalContact.class);
                organizationalContactList.add(author);
            }
        } else if (node.isObject()) {
            OrganizationalContact author = mapper.convertValue((Object)node, OrganizationalContact.class);
            organizationalContactList.add(author);
        }
        return organizationalContactList;
    }
}

