/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.LifecycleChoice;
import zz.org.cyclonedx.model.Lifecycles;

public class LifecycleDeserializer
extends JsonDeserializer<Lifecycles> {
    @Override
    public Lifecycles deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayList<LifecycleChoice> choices = new ArrayList<LifecycleChoice>();
        if (node.has("lifecycle")) {
            node = node.get("lifecycle");
        }
        if (node != null) {
            ArrayNode nodes = node.isArray() ? (ArrayNode)node : new ArrayNode(null).add(node);
            for (JsonNode choiceNode : nodes) {
                LifecycleChoice choice = this.createLifecycleChoice(choiceNode);
                if (choice == null) continue;
                choices.add(choice);
            }
        }
        Lifecycles lifecycles = new Lifecycles();
        lifecycles.setLifecycleChoice(choices);
        return lifecycles;
    }

    private LifecycleChoice createLifecycleChoice(JsonNode choiceNode) {
        LifecycleChoice choice = new LifecycleChoice();
        JsonNode phaseNode = choiceNode.get("phase");
        if (phaseNode != null) {
            LifecycleChoice.Phase phase = LifecycleChoice.Phase.fromString(phaseNode.asText());
            choice.setPhase(phase);
            return choice;
        }
        JsonNode nameNode = choiceNode.get("name");
        JsonNode descriptionNode = choiceNode.get("description");
        if (nameNode != null && descriptionNode != null) {
            choice.setName(nameNode.asText());
            choice.setDescription(descriptionNode.asText());
            return choice;
        }
        return null;
    }
}

