/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.License;
import zz.org.cyclonedx.model.LicenseChoice;

public class LicenseDeserializer
extends JsonDeserializer<LicenseChoice> {
    @Override
    public LicenseChoice deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode rootNode = (JsonNode)p.getCodec().readTree(p);
        if (!rootNode.isEmpty()) {
            ArrayNode nodes = rootNode.isArray() ? (ArrayNode)rootNode : new ArrayNode(null).add(rootNode);
            LicenseChoice licenseChoice = new LicenseChoice();
            for (JsonNode node : nodes) {
                if (node.has("license")) {
                    this.processLicenseNode(p, node.get("license"), licenseChoice);
                    continue;
                }
                if (!node.has("expression")) continue;
                licenseChoice.setExpression(node.get("expression").asText());
                return licenseChoice;
            }
            return licenseChoice;
        }
        return null;
    }

    private void processLicenseNode(JsonParser p, JsonNode licenseNode, LicenseChoice licenseChoice) throws IOException {
        ArrayNode licenseNodes = licenseNode.isArray() ? (ArrayNode)licenseNode : new ArrayNode(null).add(licenseNode);
        for (JsonNode license : licenseNodes) {
            License licenseObj = p.getCodec().treeToValue(license, License.class);
            licenseChoice.addLicense(licenseObj);
        }
    }
}

