/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ArrayNode;
import zz.org.cyclonedx.model.ExternalReference;
import zz.org.cyclonedx.model.Hash;
import zz.org.cyclonedx.util.deserializer.HashesDeserializer;

public class ExternalReferencesDeserializer
extends JsonDeserializer<List<ExternalReference>> {
    private final HashesDeserializer hashesDeserializer = new HashesDeserializer();

    @Override
    public List<ExternalReference> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.has("reference")) {
            return this.parseExternalReferences(node.get("reference"), parser, context);
        }
        return this.parseExternalReferences(node, parser, context);
    }

    private List<ExternalReference> parseExternalReferences(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<ExternalReference> references = new ArrayList<ExternalReference>();
        ArrayNode nodes = node.isArray() ? (ArrayNode)node : new ArrayNode(null).add(node);
        for (JsonNode resolvesNode : nodes) {
            ExternalReference type = this.parseExternalReference(resolvesNode, p, ctxt);
            references.add(type);
        }
        return references;
    }

    private ExternalReference parseExternalReference(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ExternalReference reference = new ExternalReference();
        if (node.has("url")) {
            reference.setUrl(node.get("url").asText());
        }
        if (node.has("type")) {
            reference.setType(ExternalReference.Type.fromString(node.get("type").asText()));
        }
        if (node.has("comment")) {
            reference.setComment(node.get("comment").asText());
        }
        if (node.has("hashes")) {
            JsonParser hashesParser = node.get("hashes").traverse(p.getCodec());
            hashesParser.nextToken();
            reference.setHashes((List<Hash>)this.hashesDeserializer.deserialize(hashesParser, ctxt));
        }
        return reference;
    }
}

