/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.util.deserializer;

import java.io.IOException;
import java.util.Arrays;
import zz.com.fasterxml.jackson.core.JsonParser;
import zz.com.fasterxml.jackson.databind.DeserializationContext;
import zz.com.fasterxml.jackson.databind.JsonDeserializer;
import zz.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import zz.org.cyclonedx.model.Ancestors;
import zz.org.cyclonedx.model.Component;
import zz.org.cyclonedx.model.ComponentWrapper;
import zz.org.cyclonedx.model.Descendants;
import zz.org.cyclonedx.model.Variants;

public class ComponentWrapperDeserializer
extends JsonDeserializer<ComponentWrapper> {
    private static final String ANCESTORS = "ancestors";
    private static final String DESCENDANTS = "descendants";
    private static final String VARIANTS = "variants";

    @Override
    public ComponentWrapper deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ComponentWrapper wrapper;
        String location = parser.getCurrentName();
        if (parser instanceof FromXmlParser) {
            switch (location) {
                case "ancestors": {
                    return parser.readValueAs(Ancestors.class);
                }
                case "descendants": {
                    return parser.readValueAs(Descendants.class);
                }
                case "variants": {
                    return parser.readValueAs(Variants.class);
                }
            }
            return null;
        }
        switch (location) {
            case "ancestors": {
                wrapper = new Ancestors();
                break;
            }
            case "descendants": {
                wrapper = new Descendants();
                break;
            }
            case "variants": {
                wrapper = new Variants();
                break;
            }
            default: {
                return null;
            }
        }
        Component[] components = parser.readValueAs(Component[].class);
        wrapper.setComponents(Arrays.asList(components));
        return wrapper;
    }
}

