/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model.vulnerability;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonProperty;
import zz.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import zz.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.OrganizationalContact;
import zz.org.cyclonedx.model.OrganizationalEntity;
import zz.org.cyclonedx.model.Property;
import zz.org.cyclonedx.model.Tool;
import zz.org.cyclonedx.model.VersionFilter;
import zz.org.cyclonedx.util.serializer.CustomDateSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"bomRef", "id", "source", "references", "ratings", "cwes", "description", "detail", "recommendation", "advisories", "created", "published", "updated", "rejected", "credits", "tools", "analysis", "affects", "properties"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Vulnerability {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    private String id;
    private Source source;
    private List<Reference> references;
    private List<Rating> ratings;
    private List<Integer> cwes;
    private String description;
    private String detail;
    private String recommendation;
    private List<Advisory> advisories;
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3"})
    private Date created;
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3"})
    private Date published;
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3"})
    private Date updated;
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
    private Date rejected;
    private Credits credits;
    @JacksonXmlElementWrapper(localName="tools")
    @JacksonXmlProperty(localName="tool")
    private List<Tool> tools;
    private Analysis analysis;
    private List<Affect> affects;
    private List<Property> properties;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    @JacksonXmlElementWrapper(localName="references")
    @JacksonXmlProperty(localName="reference")
    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    @JacksonXmlElementWrapper(localName="ratings")
    @JacksonXmlProperty(localName="rating")
    public List<Rating> getRatings() {
        return this.ratings;
    }

    public void setRatings(List<Rating> ratings) {
        this.ratings = ratings;
    }

    public void addRating(Rating rating) {
        if (this.ratings == null) {
            this.ratings = new ArrayList<Rating>();
        }
        this.ratings.add(rating);
    }

    @JacksonXmlElementWrapper(localName="cwes")
    @JacksonXmlProperty(localName="cwe")
    public List<Integer> getCwes() {
        return this.cwes;
    }

    public void setCwes(List<Integer> cwes) {
        this.cwes = cwes;
    }

    public void addCwe(int cweId) {
        if (this.cwes == null) {
            this.cwes = new ArrayList<Integer>();
        }
        this.cwes.add(cweId);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    @JacksonXmlElementWrapper(localName="advisories")
    @JacksonXmlProperty(localName="advisory")
    public List<Advisory> getAdvisories() {
        return this.advisories;
    }

    public void setAdvisories(List<Advisory> advisories) {
        this.advisories = advisories;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Date getRejected() {
        return this.rejected;
    }

    public void setRejected(Date rejected) {
        this.rejected = rejected;
    }

    public Credits getCredits() {
        return this.credits;
    }

    public void setCredits(Credits credits) {
        this.credits = credits;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(Analysis analysis) {
        this.analysis = analysis;
    }

    @JacksonXmlElementWrapper(localName="affects")
    @JacksonXmlProperty(localName="target")
    public List<Affect> getAffects() {
        return this.affects;
    }

    public void setAffects(List<Affect> affects) {
        this.affects = affects;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Credits {
        @JacksonXmlElementWrapper(localName="organizations")
        @JacksonXmlProperty(localName="organization")
        private List<OrganizationalEntity> organizations;
        @JacksonXmlElementWrapper(localName="individuals")
        @JacksonXmlProperty(localName="individual")
        private List<OrganizationalContact> individuals;

        public List<OrganizationalContact> getIndividuals() {
            return this.individuals;
        }

        public void setIndividuals(List<OrganizationalContact> individuals) {
            this.individuals = individuals;
        }

        public List<OrganizationalEntity> getOrganizations() {
            return this.organizations;
        }

        public void setOrganizations(List<OrganizationalEntity> organizations) {
            this.organizations = organizations;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Version {
        private String version;
        private String range;
        private Status status;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public static enum Status {
            AFFECTED("affected"),
            UNAFFECTED("unaffected"),
            UNKNOWN("unknown");

            private final String name;

            public String getStatusName() {
                return this.name;
            }

            private Status(String name) {
                this.name = name;
            }

            public static Status fromString(String text) {
                for (Status s : Status.values()) {
                    if (!s.name.equals(text)) continue;
                    return s;
                }
                return null;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Affect {
        private String ref;
        @JacksonXmlElementWrapper(localName="versions")
        @JacksonXmlProperty(localName="version")
        private List<Version> versions;

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public List<Version> getVersions() {
            return this.versions;
        }

        public void setVersions(List<Version> versions) {
            this.versions = versions;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"state", "justification", "responses", "detail"})
    public static class Analysis {
        private State state;
        private Justification justification;
        private List<Response> responses;
        private String detail;
        @JsonSerialize(using=CustomDateSerializer.class)
        @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
        private Date firstIssued;
        @JsonSerialize(using=CustomDateSerializer.class)
        @VersionFilter(versions={"1.0", "1.1", "1.2", "1.3", "1.4"})
        private Date lastUpdated;

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public Justification getJustification() {
            return this.justification;
        }

        public void setJustification(Justification justification) {
            this.justification = justification;
        }

        @JacksonXmlElementWrapper(localName="responses")
        @JsonProperty(value="response")
        @JacksonXmlProperty(localName="response")
        public List<Response> getResponses() {
            return this.responses;
        }

        public void setResponses(List<Response> responses) {
            this.responses = responses;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public Date getFirstIssued() {
            return this.firstIssued;
        }

        public void setFirstIssued(Date firstIssued) {
            this.firstIssued = firstIssued;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public void setLastUpdated(Date lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public static enum Response {
            CAN_NOT_FIX("can_not_fix"),
            WILL_NOT_FIX("will_not_fix"),
            UPDATE("update"),
            ROLLBACK("rollback"),
            WORKAROUND_AVAILABLE("workaround_available");

            private final String name;

            public String getResponseName() {
                return this.name;
            }

            private Response(String name) {
                this.name = name;
            }

            public static Response fromString(String text) {
                for (Response r : Response.values()) {
                    if (!r.name.equals(text)) continue;
                    return r;
                }
                return null;
            }
        }

        public static enum Justification {
            CODE_NOT_PRESENT("code_not_present"),
            CODE_NOT_REACHABLE("code_not_reachable"),
            REQUIRES_CONFIGURATION("requires_configuration"),
            REQUIRES_DEPENDENCY("requires_dependency"),
            REQUIRES_ENVIRONMENT("requires_environment"),
            PROTECTED_BY_COMPILER("protected_by_compiler"),
            PROTECTED_AT_RUNTIME("protected_at_runtime"),
            PROTECTED_AT_PERIMETER("protected_at_perimeter"),
            PROTECTED_BY_MITIGATING_CONTROL("protected_by_mitigating_control");

            private final String name;

            public String getJustificationName() {
                return this.name;
            }

            private Justification(String name) {
                this.name = name;
            }

            public static Justification fromString(String text) {
                for (Justification j : Justification.values()) {
                    if (!j.name.equals(text)) continue;
                    return j;
                }
                return null;
            }
        }

        public static enum State {
            RESOLVED("resolved"),
            RESOLVED_WITH_PEDIGREE("resolved_with_pedigree"),
            EXPLOITABLE("exploitable"),
            IN_TRIAGE("in_triage"),
            FALSE_POSITIVE("false_positive"),
            NOT_AFFECTED("not_affected");

            private final String name;

            public String getStateName() {
                return this.name;
            }

            private State(String name) {
                this.name = name;
            }

            public static State fromString(String text) {
                for (State a : State.values()) {
                    if (!a.name.equals(text)) continue;
                    return a;
                }
                return null;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Rating {
        private Source source;
        private Double score;
        private Severity severity;
        private Method method;
        private String vector;
        private String justification;

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }

        public Double getScore() {
            return this.score;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String getVector() {
            return this.vector;
        }

        public void setVector(String vector) {
            this.vector = vector;
        }

        public String getJustification() {
            return this.justification;
        }

        public void setJustification(String justification) {
            this.justification = justification;
        }

        public static enum Method {
            CVSSV2("CVSSv2"),
            CVSSV3("CVSSv3"),
            CVSSV31("CVSSv31"),
            CVSSV4("CVSSv4"),
            OWASP("OWASP"),
            SSVC("SSVC"),
            OTHER("other");

            private final String name;

            public String getMethodName() {
                return this.name;
            }

            private Method(String name) {
                this.name = name;
            }

            public static Method fromString(String text) {
                for (Method m : Method.values()) {
                    if (!m.name.equals(text)) continue;
                    return m;
                }
                return null;
            }
        }

        public static enum Severity {
            CRITICAL("critical"),
            HIGH("high"),
            MEDIUM("medium"),
            LOW("low"),
            INFO("info"),
            NONE("none"),
            UNKNOWN("unknown");

            private final String name;

            public String getSeverityName() {
                return this.name;
            }

            private Severity(String name) {
                this.name = name;
            }

            public static Severity fromString(String text) {
                for (Severity s : Severity.values()) {
                    if (!s.name.equals(text)) continue;
                    return s;
                }
                return null;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Advisory {
        private String title;
        private String url;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Source {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Reference {
        private String id;
        private Source source;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Source getSource() {
            return this.source;
        }

        public void setSource(Source source) {
            this.source = source;
        }
    }
}

