/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model.formulation;

import java.util.Date;
import java.util.List;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonProperty;
import zz.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import zz.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.Dependency;
import zz.org.cyclonedx.model.DependencyList;
import zz.org.cyclonedx.model.formulation.common.BasicDataAbstract;
import zz.org.cyclonedx.model.formulation.common.InputType;
import zz.org.cyclonedx.model.formulation.common.OutputType;
import zz.org.cyclonedx.model.formulation.task.Step;
import zz.org.cyclonedx.model.formulation.trigger.Trigger;
import zz.org.cyclonedx.model.formulation.workspace.Workspace;
import zz.org.cyclonedx.util.deserializer.DependencyDeserializer;
import zz.org.cyclonedx.util.serializer.CustomDateSerializer;
import zz.org.cyclonedx.util.serializer.DependencySerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class FormulationCommon
extends BasicDataAbstract {
    protected Trigger trigger;
    protected List<TaskType> taskTypes;
    protected List<InputType> inputs;
    protected List<OutputType> outputs;
    @JsonSerialize(using=CustomDateSerializer.class)
    @JsonProperty(value="timeStart")
    protected Date timeStart;
    @JsonSerialize(using=CustomDateSerializer.class)
    @JsonProperty(value="timeEnd")
    protected Date timeEnd;
    protected List<Workspace> workspaces;
    @JsonProperty(value="runtimeTopology")
    @JacksonXmlProperty(localName="runtimeTopology")
    @JsonSerialize(using=DependencySerializer.class, as=DependencyList.class)
    protected DependencyList runtimeTopology;
    @JsonProperty(value="taskDependencies")
    @JacksonXmlProperty(localName="taskDependencies")
    @JsonSerialize(using=DependencySerializer.class, as=DependencyList.class)
    protected DependencyList taskDependencies;
    private List<Step> steps;

    @JacksonXmlElementWrapper(localName="steps")
    @JacksonXmlProperty(localName="step")
    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=DependencyDeserializer.class)
    public List<Dependency> getTaskDependencies() {
        return this.taskDependencies;
    }

    public void setTaskDependencies(List<Dependency> taskDependencies) {
        this.taskDependencies = new DependencyList(taskDependencies);
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonDeserialize(using=DependencyDeserializer.class)
    public List<Dependency> getRuntimeTopology() {
        return this.runtimeTopology;
    }

    public void setRuntimeTopology(List<Dependency> runtimeTopology) {
        this.runtimeTopology = new DependencyList(runtimeTopology);
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    @JacksonXmlElementWrapper(localName="taskTypes")
    @JacksonXmlProperty(localName="taskType")
    public List<TaskType> getTaskTypes() {
        return this.taskTypes;
    }

    public void setTaskTypes(List<TaskType> taskTypes) {
        this.taskTypes = taskTypes;
    }

    @JacksonXmlElementWrapper(localName="inputs")
    @JacksonXmlProperty(localName="input")
    public List<InputType> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputType> inputTypes) {
        this.inputs = inputTypes;
    }

    @JacksonXmlElementWrapper(localName="outputs")
    @JacksonXmlProperty(localName="output")
    public List<OutputType> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputType> outputTypes) {
        this.outputs = outputTypes;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public void setTimeStart(Date timeStart) {
        this.timeStart = timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public void setTimeEnd(Date timeEnd) {
        this.timeEnd = timeEnd;
    }

    @JacksonXmlElementWrapper(localName="workspaces")
    @JacksonXmlProperty(localName="workspace")
    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
    }

    public static enum TaskType {
        COPY("copy"),
        CLONE("clone"),
        LINT("LINT"),
        SCAN("scan"),
        MERGE("merge"),
        BUILD("build"),
        TEST("test"),
        DELIVER("deliver"),
        DEPLOY("deploy"),
        RELEASE("release"),
        CLEAN("clean"),
        OTHER("other");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private TaskType(String name) {
            this.name = name;
        }
    }
}

