/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model;

import java.util.List;
import java.util.Objects;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import zz.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.Ancestors;
import zz.org.cyclonedx.model.Commit;
import zz.org.cyclonedx.model.Descendants;
import zz.org.cyclonedx.model.ExtensibleElement;
import zz.org.cyclonedx.model.Patch;
import zz.org.cyclonedx.model.Variants;
import zz.org.cyclonedx.model.VersionFilter;
import zz.org.cyclonedx.util.deserializer.ComponentWrapperDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"ancestors", "descendants", "variants", "commits", "patches", "notes"})
public class Pedigree
extends ExtensibleElement {
    @JsonDeserialize(using=ComponentWrapperDeserializer.class)
    private Ancestors ancestors;
    @JsonDeserialize(using=ComponentWrapperDeserializer.class)
    private Descendants descendants;
    @JsonDeserialize(using=ComponentWrapperDeserializer.class)
    private Variants variants;
    private List<Commit> commits;
    @VersionFilter(versions={"1.0", "1.1"})
    private List<Patch> patches;
    private String notes;

    public Ancestors getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(Ancestors ancestors) {
        this.ancestors = ancestors;
    }

    public Descendants getDescendants() {
        return this.descendants;
    }

    public void setDescendants(Descendants descendants) {
        this.descendants = descendants;
    }

    public Variants getVariants() {
        return this.variants;
    }

    public void setVariants(Variants variants) {
        this.variants = variants;
    }

    @JacksonXmlElementWrapper(localName="commits")
    @JacksonXmlProperty(localName="commit")
    public List<Commit> getCommits() {
        return this.commits;
    }

    public void setCommits(List<Commit> commits) {
        this.commits = commits;
    }

    @JacksonXmlElementWrapper(localName="patches")
    @JacksonXmlProperty(localName="patch")
    public List<Patch> getPatches() {
        return this.patches;
    }

    public void setPatches(List<Patch> patches) {
        this.patches = patches;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pedigree)) {
            return false;
        }
        Pedigree pedigree = (Pedigree)o;
        return Objects.equals(this.ancestors, pedigree.ancestors) && Objects.equals(this.descendants, pedigree.descendants) && Objects.equals(this.variants, pedigree.variants) && Objects.equals(this.commits, pedigree.commits) && Objects.equals(this.notes, pedigree.notes);
    }

    public int hashCode() {
        return Objects.hash(this.ancestors, this.descendants, this.variants, this.commits, this.notes);
    }
}

