/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.model;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import zz.com.fasterxml.jackson.annotation.JsonCreator;
import zz.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import zz.com.fasterxml.jackson.annotation.JsonInclude;
import zz.com.fasterxml.jackson.annotation.JsonProperty;
import zz.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import zz.com.fasterxml.jackson.annotation.JsonRootName;
import zz.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import zz.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import zz.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import zz.org.cyclonedx.model.ExtensibleElement;
import zz.org.cyclonedx.model.OrganizationalChoice;
import zz.org.cyclonedx.util.deserializer.LicensingTypeDeserializer;
import zz.org.cyclonedx.util.deserializer.OrganizationalChoiceDeserializer;
import zz.org.cyclonedx.util.deserializer.StringListDeserializer;
import zz.org.cyclonedx.util.serializer.CustomDateSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"altIds", "licensor", "licensee", "purchaser", "purchaseOrder", "licenseTypes", "lastRenewal", "expiration"})
@JsonRootName(value="licensing")
public class Licensing
extends ExtensibleElement {
    private List<String> altIds;
    @JsonDeserialize(using=OrganizationalChoiceDeserializer.class)
    private OrganizationalChoice licensor;
    @JsonDeserialize(using=OrganizationalChoiceDeserializer.class)
    private OrganizationalChoice licensee;
    @JsonDeserialize(using=OrganizationalChoiceDeserializer.class)
    private OrganizationalChoice purchaser;
    private String purchaseOrder;
    @JacksonXmlElementWrapper(localName="licenseTypes")
    @JacksonXmlProperty(localName="licenseType")
    @JsonDeserialize(using=LicensingTypeDeserializer.class)
    private List<LicensingType> licenseTypes;
    @JsonSerialize(using=CustomDateSerializer.class)
    private Date lastRenewal;
    @JsonSerialize(using=CustomDateSerializer.class)
    private Date expiration;

    @JacksonXmlElementWrapper(localName="altIds")
    @JacksonXmlProperty(localName="altId")
    @JsonDeserialize(using=StringListDeserializer.class)
    public List<String> getAltIds() {
        return this.altIds;
    }

    public void setAltIds(List<String> altIds) {
        this.altIds = altIds;
    }

    @JacksonXmlProperty(localName="licensor")
    @JsonProperty(value="licensor")
    public OrganizationalChoice getLicensor() {
        return this.licensor;
    }

    public void setLicensor(OrganizationalChoice licensor) {
        this.licensor = licensor;
    }

    @JacksonXmlProperty(localName="licensee")
    @JsonProperty(value="licensee")
    public OrganizationalChoice getLicensee() {
        return this.licensee;
    }

    public void setLicensee(OrganizationalChoice licensee) {
        this.licensee = licensee;
    }

    @JacksonXmlProperty(localName="purchaser")
    @JsonProperty(value="purchaser")
    public OrganizationalChoice getPurchaser() {
        return this.purchaser;
    }

    public void setPurchaser(OrganizationalChoice purchaser) {
        this.purchaser = purchaser;
    }

    public String getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(String purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public List<LicensingType> getLicenseTypes() {
        return this.licenseTypes;
    }

    public void setLicenseTypes(List<LicensingType> licenseTypes) {
        this.licenseTypes = licenseTypes;
    }

    public Date getLastRenewal() {
        return this.lastRenewal;
    }

    public void setLastRenewal(Date lastRenewal) {
        this.lastRenewal = lastRenewal;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Licensing)) {
            return false;
        }
        Licensing licensing = (Licensing)o;
        return Objects.equals(this.altIds, licensing.altIds) && Objects.equals(this.licensor, licensing.licensor) && Objects.equals(this.licensee, licensing.licensee) && Objects.equals(this.purchaser, licensing.purchaser) && Objects.equals(this.purchaseOrder, licensing.purchaseOrder) && Objects.equals(this.licenseTypes, licensing.licenseTypes) && Objects.equals(this.lastRenewal, licensing.lastRenewal) && Objects.equals(this.expiration, licensing.expiration);
    }

    public int hashCode() {
        return Objects.hash(this.altIds, this.licensor, this.licensee, this.purchaser, this.purchaseOrder, this.licenseTypes, this.lastRenewal, this.expiration);
    }

    public static enum LicensingType {
        ACADEMIC("academic"),
        APPLIANCE("appliance"),
        CLIENT_ACCESS("client-access"),
        CONCURRENT_USER("concurrent-user"),
        CORE_POINTS("core-points"),
        CUSTOM_METRIC("custom-metric"),
        DEVICE("device"),
        EVALUATION("evaluation"),
        NAMED_USER("named-user"),
        NODE_LOCKED("node-locked"),
        OEM("oem"),
        PERPETUAL("perpetual"),
        PROCESSOR_POINTS("processor-points"),
        SUBSCRIPTION("subscription"),
        USER("user"),
        OTHER("other");

        private final String name;

        public String getLicensingType() {
            return this.name;
        }

        private LicensingType(String name) {
            this.name = name;
        }

        @JsonCreator
        public static LicensingType fromString(String value) {
            for (LicensingType type : LicensingType.values()) {
                if (!type.name.equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid licensing type: " + value);
        }
    }
}

