/*
 * Decompiled with CFR 0.152.
 */
package zz.org.cyclonedx.generators.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import zz.com.fasterxml.jackson.core.JsonProcessingException;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.databind.module.SimpleModule;
import zz.com.fasterxml.jackson.dataformat.xml.XmlMapper;
import zz.com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.generators.xml.BomXmlGenerator;
import zz.org.cyclonedx.model.Bom;
import zz.org.cyclonedx.util.VersionXmlAnnotationIntrospector;
import zz.org.cyclonedx.util.serializer.DependencySerializer;
import zz.org.cyclonedx.util.serializer.InputTypeSerializer;
import zz.org.cyclonedx.util.serializer.LifecycleSerializer;
import zz.org.cyclonedx.util.serializer.MetadataSerializer;
import zz.org.cyclonedx.util.serializer.OutputTypeSerializer;

public abstract class AbstractBomXmlGenerator
extends CycloneDxSchema
implements BomXmlGenerator {
    private final ObjectMapper mapper = new XmlMapper();
    private final DefaultXmlPrettyPrinter prettyPrinter = new DefaultXmlPrettyPrinter();
    Document doc;
    protected static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public AbstractBomXmlGenerator() {
        this.setupObjectMapper(this.mapper);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector(new VersionXmlAnnotationIntrospector(String.valueOf(this.getSchemaVersion().getVersion())));
        if (this.getSchemaVersion().getVersion() != 1.0) {
            boolean useNamespace = this.getSchemaVersion().getVersion() == 1.1;
            this.registerDependencyModule(mapper, useNamespace);
        }
        SimpleModule lifecycleModule = new SimpleModule();
        lifecycleModule.addSerializer(new LifecycleSerializer(true));
        mapper.registerModule(lifecycleModule);
        SimpleModule metadataModule = new SimpleModule();
        metadataModule.addSerializer(new MetadataSerializer(true, this.getSchemaVersion()));
        mapper.registerModule(metadataModule);
        SimpleModule inputTypeModule = new SimpleModule();
        inputTypeModule.addSerializer(new InputTypeSerializer(true));
        mapper.registerModule(inputTypeModule);
        SimpleModule outputTypeModule = new SimpleModule();
        outputTypeModule.addSerializer(new OutputTypeSerializer(false));
        mapper.registerModule(outputTypeModule);
    }

    private void registerDependencyModule(ObjectMapper mapper, boolean useNamespace) {
        SimpleModule depModule = new SimpleModule();
        depModule.addSerializer(new DependencySerializer(useNamespace, null));
        mapper.registerModule(depModule);
    }

    public DocumentBuilder buildSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    protected Document generateDocument(Bom bom) throws ParserConfigurationException {
        try {
            DocumentBuilder docBuilder = this.buildSecureDocumentBuilder();
            this.doc = docBuilder.parse(new InputSource(new StringReader(this.toXML(bom, false))));
            this.doc.setXmlStandalone(true);
            return this.doc;
        }
        catch (IOException | ParserConfigurationException | SAXException | GeneratorException ex) {
            throw new ParserConfigurationException(ex.toString());
        }
    }

    String toXML(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            if (prettyPrint) {
                return PROLOG + System.lineSeparator() + this.mapper.writer(this.prettyPrinter).writeValueAsString(bom);
            }
            return PROLOG + this.mapper.writeValueAsString(bom);
        }
        catch (JsonProcessingException ex) {
            throw new GeneratorException(ex);
        }
    }

    @Override
    public String toString() {
        try {
            return this.toXmlString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

