/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import zz.de.schlichtherle.truezip.io.DecoratingOutputStream;
import zz.de.schlichtherle.truezip.io.DisconnectingOutputStream;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.OutputBusyException;
import zz.de.schlichtherle.truezip.io.SequentialIOException;
import zz.de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.HashMaps;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@NotThreadSafe
public class TarOutputShop
extends TarArchiveOutputStream
implements OutputShop<TarDriverEntry> {
    public static final int OVERHEAD_SIZE = 47;
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity(47));
    private final IOPool<?> pool;
    private boolean busy;

    @CreatesObligation
    public TarOutputShop(TarDriver driver, @WillCloseWhenClosed OutputStream out) {
        super(out, 10240, 512, driver.getEncoding());
        super.setAddPaxHeadersForNonAsciiNames(true);
        super.setLongFileMode(3);
        super.setBigNumberMode(2);
        this.pool = driver.getPool();
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @Override
    @CheckForNull
    public TarDriverEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public OutputSocket<TarDriverEntry> getOutputSocket(final TarDriverEntry local) {
        if (null == local) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<TarDriverEntry> {
            Output() {
            }

            @Override
            public TarDriverEntry getLocalTarget() {
                return local;
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (TarOutputShop.this.isBusy()) {
                    throw new OutputBusyException(local.getName());
                }
                if (local.isDirectory()) {
                    TarOutputShop.this.updateProperties(local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(local);
                }
                TarOutputShop.this.updateProperties(local, this.getPeerTarget());
                return -1L == local.getSize() ? new BufferedEntryOutputStream(local) : new EntryOutputStream(local);
            }
        }
        return new Output();
    }

    void updateProperties(TarDriverEntry local, @CheckForNull Entry peer) {
        if (-1L == local.getModTime().getTime()) {
            local.setModTime(System.currentTimeMillis());
        }
        if (null != peer && -1L == local.getSize()) {
            local.setSize(peer.getSize(Entry.Size.DATA));
        }
    }

    private boolean isBusy() {
        return this.busy;
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IOPool.Entry<?> buffer;
        final TarDriverEntry local;
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        BufferedEntryOutputStream(TarDriverEntry local) throws IOException {
            super(null);
            this.local = local;
            IOPool.Entry buffer = this.buffer = (IOPool.Entry)TarOutputShop.this.pool.allocate();
            try {
                this.delegate = buffer.getOutputSocket().newOutputStream();
            }
            catch (IOException ex) {
                block4: {
                    try {
                        buffer.release();
                    }
                    catch (IOException ex2) {
                        if (!JSE7.AVAILABLE) break block4;
                        ex.addSuppressed(ex2);
                    }
                }
                throw ex;
            }
            TarOutputShop.this.entries.put(local.getName(), local);
            TarOutputShop.this.busy = true;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            this.delegate.close();
            TarOutputShop.this.updateProperties(this.local, this.buffer);
            this.storeBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IOPool.Entry<?> buffer = this.buffer;
            SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            try {
                InputStream in = buffer.getInputSocket().newInputStream();
                try {
                    TarOutputShop taos = TarOutputShop.this;
                    taos.putArchiveEntry(this.local);
                    try {
                        Streams.cat(in, taos);
                    }
                    catch (InputException ex) {
                        builder.warn(ex);
                    }
                    try {
                        taos.closeArchiveEntry();
                    }
                    catch (IOException ex) {
                        builder.warn(ex);
                    }
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        builder.warn(ex);
                    }
                }
            }
            finally {
                try {
                    buffer.release();
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            builder.check();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(TarDriverEntry local) throws IOException {
            super(TarOutputShop.this);
            TarOutputShop.this.putArchiveEntry(local);
            TarOutputShop.this.entries.put(local.getName(), local);
            TarOutputShop.this.busy = true;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            TarOutputShop.this.busy = false;
            TarOutputShop.this.closeArchiveEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getSize(Entry.Size type) {
            return 0L;
        }

        @Override
        public long getTime(Entry.Access type) {
            return -1L;
        }
    }
}

