/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsCharsetArchiveDriver;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriverEntry;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import zz.de.schlichtherle.truezip.socket.IOPool;
import zz.de.schlichtherle.truezip.socket.IOPoolProvider;
import zz.de.schlichtherle.truezip.socket.InputShop;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.MultiplexedOutputShop;
import zz.de.schlichtherle.truezip.socket.OutputShop;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.org.apache.commons.compress.archivers.tar.TarArchiveEntry;

@Immutable
public class TarDriver
extends FsCharsetArchiveDriver<TarDriverEntry> {
    public static final Charset TAR_CHARSET = Charset.defaultCharset();
    private final IOPool<?> ioPool;

    public TarDriver(IOPoolProvider provider) {
        super(TAR_CHARSET);
        this.ioPool = provider.get();
        if (null == this.ioPool) {
            throw new NullPointerException();
        }
    }

    final String getEncoding() {
        return this.getCharset().name();
    }

    @Override
    protected final IOPool<?> getPool() {
        return this.ioPool;
    }

    @Override
    public boolean getRedundantContentSupport() {
        return true;
    }

    @Override
    public InputSocket<?> getInputSocket(FsController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
        return controller.getInputSocket(name, options.clear(FsInputOption.CACHE));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set(FsOutputOption.COMPRESS), template);
    }

    @Override
    public TarDriverEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        TarDriverEntry entry;
        name = TarDriver.toZipOrTarEntryName(name, type);
        if (template instanceof TarArchiveEntry) {
            entry = this.newEntry(name, (TarArchiveEntry)((Object)template));
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setModTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        return entry;
    }

    public TarDriverEntry newEntry(String name) {
        return new TarDriverEntry(name);
    }

    public TarDriverEntry newEntry(String name, TarArchiveEntry template) {
        return new TarDriverEntry(name, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TarInputShop newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        TarInputShop is = null;
        InputStream in = input.newInputStream();
        try {
            TarInputShop tarInputShop = is = this.newTarInputShop(model, in);
            return tarInputShop;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                if (null != is) {
                    is.close();
                }
                throw ex;
            }
        }
    }

    @CreatesObligation
    protected TarInputShop newTarInputShop(FsModel model, @WillCloseWhenClosed InputStream in) throws IOException {
        assert (null != model);
        return new TarInputShop(this, in);
    }

    @Override
    public OutputShop<TarDriverEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<TarDriverEntry> source) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        OutputStream out = output.newOutputStream();
        try {
            return new MultiplexedOutputShop<TarDriverEntry>(this.newTarOutputShop(model, out, (TarInputShop)source), this.getPool());
        }
        catch (IOException ex) {
            block5: {
                try {
                    out.close();
                }
                catch (IOException ex2) {
                    if (!JSE7.AVAILABLE) break block5;
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
    }

    @CreatesObligation
    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, @CheckForNull @WillNotClose TarInputShop source) throws IOException {
        assert (null != model);
        return new TarOutputShop(this, out);
    }
}

