/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs.archive.tar;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsController;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.fs.archive.tar.FixedBufferedOutputStream;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import zz.de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import zz.de.schlichtherle.truezip.socket.IOPoolProvider;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

@Immutable
public class TarBZip2Driver
extends TarDriver {
    public static final int BUFFER_SIZE = 8192;

    public TarBZip2Driver(IOPoolProvider provider) {
        super(provider);
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getLevel() {
        return 9;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set(FsOutputOption.STORE), template);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel model, InputStream in) throws IOException {
        return super.newTarInputShop(model, new BZip2CompressorInputStream(new BufferedInputStream(in, this.getBufferSize())));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, TarInputShop source) throws IOException {
        return super.newTarOutputShop(model, new FixedBZip2CompressorOutputStream(new FixedBufferedOutputStream(out, this.getBufferSize()), this.getLevel()), source);
    }

    private static final class FixedBZip2CompressorOutputStream
    extends BZip2CompressorOutputStream {
        final FixedBufferedOutputStream out;

        FixedBZip2CompressorOutputStream(FixedBufferedOutputStream out, int level) throws IOException {
            super(out, level);
            this.out = out;
        }

        @Override
        public void close() throws IOException {
            this.out.ignoreClose = true;
            super.close();
            this.out.ignoreClose = false;
            this.out.close();
        }
    }
}

