/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.entry.DecoratingEntry;
import zz.de.schlichtherle.truezip.entry.Entry;
import zz.de.schlichtherle.truezip.fs.FsArchiveEntry;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystem;
import zz.de.schlichtherle.truezip.fs.FsArchiveFileSystemOperation;
import zz.de.schlichtherle.truezip.fs.FsCovariantEntry;
import zz.de.schlichtherle.truezip.fs.FsEntry;
import zz.de.schlichtherle.truezip.fs.FsEntryName;
import zz.de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import zz.de.schlichtherle.truezip.fs.FsFalsePositiveArchiveException;
import zz.de.schlichtherle.truezip.fs.FsInputOption;
import zz.de.schlichtherle.truezip.fs.FsInputOptions;
import zz.de.schlichtherle.truezip.fs.FsLockModel;
import zz.de.schlichtherle.truezip.fs.FsLockModelController;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsNeedsSyncException;
import zz.de.schlichtherle.truezip.fs.FsOperationContext;
import zz.de.schlichtherle.truezip.fs.FsOutputOption;
import zz.de.schlichtherle.truezip.io.InputException;
import zz.de.schlichtherle.truezip.io.Streams;
import zz.de.schlichtherle.truezip.socket.DelegatingInputSocket;
import zz.de.schlichtherle.truezip.socket.InputSocket;
import zz.de.schlichtherle.truezip.socket.OutputSocket;
import zz.de.schlichtherle.truezip.util.BitField;

@NotThreadSafe
abstract class FsBasicArchiveController<E extends FsArchiveEntry>
extends FsLockModelController {
    private static final Logger logger = Logger.getLogger(FsBasicArchiveController.class.getName(), FsBasicArchiveController.class.getName());
    private final ThreadLocal<FsOperationContext> context = new ThreadLocal();

    FsBasicArchiveController(FsLockModel model) {
        super(model);
        if (null == model.getParent()) {
            throw new IllegalArgumentException();
        }
    }

    @Nullable
    final FsOperationContext getContext() {
        return this.context.get();
    }

    final void setContext(@CheckForNull FsOperationContext context) {
        if (null != context) {
            this.context.set(context);
        } else {
            this.context.remove();
        }
    }

    final FsArchiveFileSystem<E> autoMount() throws IOException {
        return this.autoMount(false);
    }

    abstract FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

    @Override
    public final boolean isReadOnly() throws IOException {
        return this.autoMount().isReadOnly();
    }

    @Override
    public final FsEntry getEntry(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name);
    }

    @Override
    public final boolean isReadable(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name) != null;
    }

    @Override
    public final boolean isWritable(FsEntryName name) throws IOException {
        return this.autoMount().isWritable(name);
    }

    @Override
    public final void setReadOnly(FsEntryName name) throws IOException {
        this.autoMount().setReadOnly(name);
    }

    @Override
    public final boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        this.checkSync(name, null);
        return this.autoMount().setTime(name, times);
    }

    @Override
    public final boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        this.checkSync(name, null);
        return this.autoMount().setTime(name, types, value);
    }

    @Override
    public final InputSocket<?> getInputSocket(final FsEntryName name, BitField<FsInputOption> options) {
        if (null == name) {
            throw new NullPointerException();
        }
        final class Input
        extends DelegatingInputSocket<FsArchiveEntry> {
            Input() {
            }

            @Override
            public FsArchiveEntry getLocalTarget() throws IOException {
                FsBasicArchiveController.this.checkSync(name, Entry.Access.READ);
                FsCovariantEntry ce = FsBasicArchiveController.this.autoMount().getEntry(name);
                if (null == ce) {
                    throw new FsEntryNotFoundException((FsModel)FsBasicArchiveController.this.getModel(), name, "no such entry");
                }
                Object ae = ce.get(Entry.Type.FILE);
                if (null == ae) {
                    throw new FsEntryNotFoundException((FsModel)FsBasicArchiveController.this.getModel(), name, "expected FILE entry, but is a " + ce.getTypes() + " entry");
                }
                return ae;
            }

            @Override
            protected InputSocket<? extends FsArchiveEntry> getDelegate() throws IOException {
                this.getPeerTarget();
                return FsBasicArchiveController.this.getInputSocket(this.getLocalTarget().getName());
            }
        }
        return new Input();
    }

    abstract InputSocket<? extends E> getInputSocket(String var1);

    @Override
    public final OutputSocket<?> getOutputSocket(final FsEntryName name, final BitField<FsOutputOption> options, final Entry template) {
        if (null == name) {
            throw new NullPointerException();
        }
        if (null == options) {
            throw new NullPointerException();
        }
        final class Output
        extends OutputSocket<FsArchiveEntry> {
            Output() {
            }

            @Override
            public FsArchiveEntry getLocalTarget() throws IOException {
                Object ae = ((FsCovariantEntry)this.mknod().getTarget()).getEntry();
                if (options.get(FsOutputOption.APPEND)) {
                    return new ProxyEntry((FsArchiveEntry)ae);
                }
                return ae;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OutputStream newOutputStream() throws IOException {
                FsArchiveFileSystemOperation mknod = this.mknod();
                Object ae = ((FsCovariantEntry)mknod.getTarget()).getEntry();
                InputStream in = null;
                if (options.get(FsOutputOption.APPEND)) {
                    try {
                        in = FsBasicArchiveController.this.getInputSocket(name, FsInputOptions.NONE).newInputStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    OutputSocket os = FsBasicArchiveController.this.getOutputSocket(ae);
                    if (null == in) {
                        os.bind(this);
                    }
                    OutputStream out = os.newOutputStream();
                    try {
                        mknod.commit();
                        if (in != null) {
                            Streams.cat(in, out);
                        }
                    }
                    catch (IOException ex) {
                        out.close();
                        throw ex;
                    }
                    OutputStream outputStream = out;
                    return outputStream;
                }
                finally {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new InputException(ex);
                        }
                    }
                }
            }

            FsArchiveFileSystemOperation<E> mknod() throws IOException {
                FsBasicArchiveController.this.checkSync(name, Entry.Access.WRITE);
                return FsBasicArchiveController.this.autoMount(!name.isRoot() && options.get(FsOutputOption.CREATE_PARENTS)).mknod(name, Entry.Type.FILE, options, template);
            }
        }
        return new Output();
    }

    abstract OutputSocket<? extends E> getOutputSocket(E var1);

    @Override
    public final void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        if (name.isRoot()) {
            try {
                this.autoMount();
            }
            catch (FsFalsePositiveArchiveException ex) {
                if (Entry.Type.DIRECTORY != type) {
                    throw ex;
                }
                this.autoMount(true);
                return;
            }
            throw new FsEntryNotFoundException((FsModel)this.getModel(), name, "directory entry exists already");
        }
        this.checkSync(name, null);
        this.autoMount(options.get(FsOutputOption.CREATE_PARENTS)).mknod(name, type, options, template).commit();
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        int size;
        this.checkSync(name, null);
        FsArchiveFileSystem<E> fs = this.autoMount();
        fs.unlink(name);
        if (name.isRoot() && 0 != (size = fs.getSize() - 1)) {
            logger.log(Level.WARNING, "unlink.absolute", new Object[]{this.getMountPoint(), size});
        }
    }

    abstract void checkSync(FsEntryName var1, @CheckForNull Entry.Access var2) throws FsNeedsSyncException;

    private static final class ProxyEntry
    extends DecoratingEntry<FsArchiveEntry>
    implements FsArchiveEntry {
        ProxyEntry(FsArchiveEntry entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return ((FsArchiveEntry)this.delegate).getType();
        }

        @Override
        public boolean setSize(Entry.Size type, long value) {
            return ((FsArchiveEntry)this.delegate).setSize(type, value);
        }

        @Override
        public boolean setTime(Entry.Access type, long value) {
            return ((FsArchiveEntry)this.delegate).setTime(type, value);
        }
    }
}

