/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file.swing;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import zz.de.schlichtherle.truezip.file.TArchiveDetector;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.swing.TDecoratingFileSystemView;
import zz.de.schlichtherle.truezip.file.swing.TFileView;

public class TFileSystemView
extends TDecoratingFileSystemView {
    @CheckForNull
    private TArchiveDetector archiveDetector;

    public TFileSystemView() {
        this(FileSystemView.getFileSystemView(), null);
    }

    public TFileSystemView(FileSystemView fileSystemView) {
        this(fileSystemView, null);
    }

    public TFileSystemView(FileSystemView fileSystemView, @CheckForNull TArchiveDetector archiveDetector) {
        super(fileSystemView);
        this.archiveDetector = archiveDetector;
    }

    @CheckForNull
    public TArchiveDetector getArchiveDetector() {
        return this.archiveDetector;
    }

    public void setArchiveDetector(@CheckForNull TArchiveDetector archiveDetector) {
        this.archiveDetector = archiveDetector;
    }

    protected TFile wrap(File file) {
        if (null == file) {
            return null;
        }
        return file instanceof TFile ? (TFile)file : new TFile(file, this.getArchiveDetector());
    }

    protected File unwrap(File file) {
        return file instanceof TFile ? ((TFile)file).getFile() : file;
    }

    @Override
    public boolean isRoot(File file) {
        return this.delegate.isRoot(this.unwrap(file));
    }

    @Override
    public Boolean isTraversable(File file) {
        TFile tfile = this.wrap(file);
        return null != tfile ? Boolean.valueOf(tfile.isDirectory()) : this.delegate.isTraversable(this.unwrap(file));
    }

    @Override
    public String getSystemDisplayName(File file) {
        TFile tfile = this.wrap(file);
        if (tfile.isArchive() || tfile.isEntry()) {
            return tfile.getName();
        }
        return this.delegate.getSystemDisplayName(this.unwrap(file));
    }

    @Override
    public String getSystemTypeDescription(File file) {
        TFile tfile = this.wrap(file);
        String typeDescription = TFileView.typeDescription((File)tfile);
        if (typeDescription != null) {
            return typeDescription;
        }
        return this.delegate.getSystemTypeDescription(this.unwrap(file));
    }

    @Override
    public Icon getSystemIcon(File file) {
        TFile tfile = this.wrap(file);
        Icon icon = TFileView.icon((File)tfile);
        if (null != icon) {
            return icon;
        }
        File uFile = this.unwrap(file);
        return uFile.exists() ? this.delegate.getSystemIcon(uFile) : null;
    }

    @Override
    public boolean isParent(File folder, File file) {
        return this.delegate.isParent(this.wrap(folder), this.wrap(file)) || this.delegate.isParent(this.unwrap(folder), this.unwrap(file));
    }

    @Override
    public File getChild(File parent, String child) {
        TFile wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            return this.createFileObject(this.delegate.getChild(wParent, child));
        }
        return this.createFileObject(this.delegate.getChild(this.unwrap(parent), child));
    }

    @Override
    public boolean isFileSystem(File file) {
        return this.delegate.isFileSystem(this.unwrap(file));
    }

    @Override
    public File createNewFolder(File parent) throws IOException {
        TFile wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            TFile folder = new TFile((File)wParent, UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"), this.getArchiveDetector());
            int i = 2;
            while (!folder.mkdirs()) {
                if (i > 100) {
                    throw new IOException(wParent + ": Could not create new directory entry!");
                }
                folder = new TFile((File)wParent, MessageFormat.format(UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), i), this.getArchiveDetector());
                ++i;
            }
            return folder;
        }
        return this.createFileObject(this.delegate.createNewFolder(this.unwrap(parent)));
    }

    @Override
    public boolean isHiddenFile(File file) {
        return this.delegate.isHiddenFile(this.unwrap(file));
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        return this.delegate.isFileSystemRoot(this.unwrap(file));
    }

    @Override
    public boolean isDrive(File file) {
        return this.delegate.isDrive(this.unwrap(file));
    }

    @Override
    public boolean isFloppyDrive(File file) {
        return this.delegate.isFloppyDrive(this.unwrap(file));
    }

    @Override
    public boolean isComputerNode(File file) {
        return this.delegate.isComputerNode(this.unwrap(file));
    }

    @Override
    public File createFileObject(File dir, String str) {
        return this.createFileObject(this.delegate.createFileObject(dir, str));
    }

    @Override
    public File createFileObject(String str) {
        return this.createFileObject(this.delegate.createFileObject(str));
    }

    @Nullable
    public File createFileObject(@CheckForNull File file) {
        if (null == file) {
            return null;
        }
        TFile tfile = this.wrap(file);
        return tfile.isArchive() || tfile.isEntry() ? tfile : this.unwrap(file);
    }

    @Override
    public File[] getFiles(File dir, final boolean useFileHiding) {
        TFile smartDir = this.wrap(dir);
        if (smartDir.isArchive() || smartDir.isEntry()) {
            class Filter
            implements FileFilter {
                Filter() {
                }

                @Override
                public boolean accept(File file) {
                    return !useFileHiding || !TFileSystemView.this.isHiddenFile(file);
                }
            }
            File[] files = smartDir.listFiles(new Filter());
            return null == files ? new TFile[]{} : files;
        }
        File[] files = this.delegate.getFiles(this.unwrap(dir), useFileHiding);
        int i = files.length;
        while (--i >= 0) {
            files[i] = this.createFileObject(files[i]);
        }
        return files;
    }

    @Override
    public File getParentDirectory(File file) {
        TFile tfile = this.wrap(file);
        if (tfile.isEntry()) {
            return this.createFileObject(tfile.getParentFile());
        }
        return this.createFileObject(this.delegate.getParentDirectory(this.unwrap(file)));
    }
}

