/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.file;

import java.net.URI;
import java.net.URISyntaxException;
import zz.de.schlichtherle.truezip.file.ExpertFeature;
import zz.de.schlichtherle.truezip.file.TConfig;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.fs.FsFilteringManager;
import zz.de.schlichtherle.truezip.fs.FsModel;
import zz.de.schlichtherle.truezip.fs.FsMountPoint;
import zz.de.schlichtherle.truezip.fs.FsSyncException;
import zz.de.schlichtherle.truezip.fs.FsSyncOption;
import zz.de.schlichtherle.truezip.fs.FsSyncOptions;
import zz.de.schlichtherle.truezip.fs.FsUriModifier;
import zz.de.schlichtherle.truezip.util.BitField;

public final class TVFS {
    private TVFS() {
    }

    public static void umount() throws FsSyncException {
        TVFS.sync(FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile tree) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    public static void umount(FsMountPoint tree) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    static FsMountPoint mountPoint(TFile tree) {
        if (tree.isArchive()) {
            return ((FsModel)tree.getController().getModel()).getMountPoint();
        }
        try {
            return new FsMountPoint(new URI(tree.getFile().toURI() + "/"), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(BitField<FsSyncOption> options) throws FsSyncException {
        TConfig.get().getFsManager().sync(options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(TFile tree, BitField<FsSyncOption> options) throws FsSyncException {
        TVFS.sync(TVFS.mountPoint(tree), options);
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, FsSyncOption ... options) throws FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    @ExpertFeature(value={ExpertFeature.Reason.THE_PRESENCE_OR_ABSENCE_OF_SOME_OPTIONS_MAY_YIELD_UNWANTED_SIDE_EFFECTS})
    public static void sync(FsMountPoint tree, BitField<FsSyncOption> options) throws FsSyncException {
        new FsFilteringManager(TConfig.get().getFsManager(), tree).sync(options);
    }
}

