/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.entry;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import zz.de.schlichtherle.truezip.util.UriBuilder;

@Immutable
public class EntryName
implements Serializable,
Comparable<EntryName> {
    private static final long serialVersionUID = 2927354934726235478L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;

    @Deprecated
    public static EntryName create(String uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public static EntryName create(URI uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public EntryName(String uri) throws URISyntaxException {
        this.parse(new URI(uri));
    }

    public EntryName(URI uri) throws URISyntaxException {
        this.parse(uri);
    }

    public EntryName(EntryName parent, EntryName member) {
        URI pu = parent.uri;
        String pup = pu.getRawPath();
        URI mu = member.uri;
        try {
            this.uri = pup.isEmpty() ? mu : (pup.endsWith(SEPARATOR) ? pu.resolve(mu) : (mu.getPath().isEmpty() ? new UriBuilder(pu, true).query(mu.getRawQuery()).getUri() : new UriBuilder(true).path(pup + '/').getUri().resolve(mu)));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()));
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri) throws URISyntaxException {
        if (uri.isAbsolute()) {
            throw new QuotedUriSyntaxException(uri, "Scheme component defined.");
        }
        if (null != uri.getRawAuthority()) {
            throw new QuotedUriSyntaxException(uri, "Authority component defined.");
        }
        if (null == uri.getRawPath()) {
            throw new QuotedUriSyntaxException(uri, "Path component undefined.");
        }
        if (null != uri.getRawFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment component defined.");
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (!this.toUri().isAbsolute());
        assert (null != this.toUri().getRawPath());
        assert (null == this.toUri().getRawFragment());
        return true;
    }

    public final URI toUri() {
        return this.uri;
    }

    @Deprecated
    public final URI getUri() {
        return this.uri;
    }

    public final String getPath() {
        return this.uri.getPath();
    }

    @CheckForNull
    public final String getQuery() {
        return this.uri.getQuery();
    }

    @CheckForNull
    public final String getFragment() {
        return this.uri.getFragment();
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof EntryName && this.uri.equals(((EntryName)that).uri);
    }

    @Override
    public final int compareTo(EntryName that) {
        return this.uri.compareTo(that.uri);
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    public final String toString() {
        return this.uri.toString();
    }
}

