/*
 * Decompiled with CFR 0.152.
 */
package zz.com.thoughtworks.xstream.converters.reflection;

import java.io.Serializable;
import zz.com.thoughtworks.xstream.converters.MarshallingContext;
import zz.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import zz.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import zz.com.thoughtworks.xstream.core.ClassLoaderReference;
import zz.com.thoughtworks.xstream.core.JVM;
import zz.com.thoughtworks.xstream.core.util.Types;
import zz.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import zz.com.thoughtworks.xstream.mapper.Mapper;

public class LambdaConverter
extends SerializableConverter {
    public LambdaConverter(Mapper mapper, ReflectionProvider reflectionProvider, ClassLoaderReference classLoaderReference) {
        super(mapper, reflectionProvider, classLoaderReference);
    }

    @Override
    public boolean canConvert(Class type) {
        return Types.isLambdaType(type) && (JVM.canCreateDerivedObjectOutputStream() || !Serializable.class.isAssignableFrom(type));
    }

    @Override
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (original instanceof Serializable) {
            super.marshal(original, writer, context);
        }
    }
}

