/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema.utils;

import java.util.BitSet;
import zz.com.networknt.schema.utils.UCDLoader;

public class UnicodeDatabase {
    private static final BitSet ARABIC_INDIC_DIGITS = new BitSet(69632);
    private static final BitSet EXTENDED_ARABIC_INDIC_DIGITS = new BitSet(69632);
    private static final BitSet GREEK_CHARACTERS = new BitSet(8192);
    private static final BitSet HEBREW_CHARACTERS = new BitSet(1536);
    private static final BitSet KATAKANA_CHARACTERS = new BitSet(208896);
    private static final BitSet JOIN_TYPE_CAUSING = new BitSet(0x110000);
    private static final BitSet JOIN_TYPE_DUAL = new BitSet(0x110000);
    private static final BitSet JOIN_TYPE_LEFT = new BitSet(0x110000);
    private static final BitSet JOIN_TYPE_RIGHT = new BitSet(0x110000);
    private static final BitSet JOIN_TYPE_TRANSPARENT = new BitSet(0x110000);

    public static boolean isArabicIndicDigit(int codepoint) {
        return ARABIC_INDIC_DIGITS.get(codepoint);
    }

    public static boolean isExtendedArabicIndicDigit(int codepoint) {
        return EXTENDED_ARABIC_INDIC_DIGITS.get(codepoint);
    }

    public static boolean isGreek(int codepoint) {
        return GREEK_CHARACTERS.get(codepoint);
    }

    public static boolean isHebrew(int codepoint) {
        return HEBREW_CHARACTERS.get(codepoint);
    }

    public static boolean isKatakana(int codepoint) {
        return KATAKANA_CHARACTERS.get(codepoint);
    }

    public static boolean isJoinTypeCausing(int codepoint) {
        if (JOIN_TYPE_CAUSING.isEmpty()) {
            UnicodeDatabase.loadJoiningTypes();
        }
        return JOIN_TYPE_CAUSING.get(codepoint);
    }

    public static boolean isJoinTypeDual(int codepoint) {
        if (JOIN_TYPE_DUAL.isEmpty()) {
            UnicodeDatabase.loadJoiningTypes();
        }
        return JOIN_TYPE_DUAL.get(codepoint);
    }

    public static boolean isJoinTypeLeft(int codepoint) {
        if (JOIN_TYPE_LEFT.isEmpty()) {
            UnicodeDatabase.loadJoiningTypes();
        }
        return JOIN_TYPE_LEFT.get(codepoint);
    }

    public static boolean isJoinTypeRight(int codepoint) {
        if (JOIN_TYPE_RIGHT.isEmpty()) {
            UnicodeDatabase.loadJoiningTypes();
        }
        return JOIN_TYPE_RIGHT.get(codepoint);
    }

    public static boolean isJoinTypeTransparent(int codepoint) {
        if (JOIN_TYPE_TRANSPARENT.isEmpty()) {
            UnicodeDatabase.loadJoiningTypes();
        }
        return JOIN_TYPE_TRANSPARENT.get(codepoint);
    }

    private static synchronized void loadJoiningTypes() {
        if (JOIN_TYPE_DUAL.isEmpty()) {
            UCDLoader.loadMapping("/ucd/extracted/DerivedJoiningType.txt", v -> {
                switch (v) {
                    case "C": {
                        return JOIN_TYPE_CAUSING;
                    }
                    case "D": {
                        return JOIN_TYPE_DUAL;
                    }
                    case "L": {
                        return JOIN_TYPE_LEFT;
                    }
                    case "R": {
                        return JOIN_TYPE_RIGHT;
                    }
                    case "T": {
                        return JOIN_TYPE_TRANSPARENT;
                    }
                }
                return null;
            });
        }
    }

    static {
        ARABIC_INDIC_DIGITS.set(1632, 1642);
        EXTENDED_ARABIC_INDIC_DIGITS.set(1776, 1786);
        GREEK_CHARACTERS.set(880, 1024);
        GREEK_CHARACTERS.set(7936, 8192);
        HEBREW_CHARACTERS.set(1424, 1536);
        KATAKANA_CHARACTERS.set(11904, 12032);
        KATAKANA_CHARACTERS.set(12032, 12256);
        KATAKANA_CHARACTERS.set(12288, 12352);
        KATAKANA_CHARACTERS.set(12352, 12448);
        KATAKANA_CHARACTERS.set(12448, 12544);
        KATAKANA_CHARACTERS.set(13312, 19904);
        KATAKANA_CHARACTERS.set(19968, 40960);
        KATAKANA_CHARACTERS.set(63744, 64256);
        KATAKANA_CHARACTERS.set(94176, 94208);
        KATAKANA_CHARACTERS.set(131072, 173792);
        KATAKANA_CHARACTERS.set(173824, 177984);
        KATAKANA_CHARACTERS.set(177984, 178208);
        KATAKANA_CHARACTERS.set(178208, 183984);
        KATAKANA_CHARACTERS.set(183984, 191472);
        KATAKANA_CHARACTERS.set(194560, 195104);
        KATAKANA_CHARACTERS.set(196608, 201552);
        KATAKANA_CHARACTERS.set(201552, 205744);
    }
}

