/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@FunctionalInterface
public interface URITranslator {
    public static final URITranslator NOOP = original -> original;

    public URI translate(URI var1);

    public static URITranslator map(String source, String target) {
        return URITranslator.map(URI.create(source), URI.create(target));
    }

    public static URITranslator map(URI source, URI target) {
        return original -> Objects.equals(source, original) ? target : original;
    }

    public static URITranslator map(Map<String, String> uriMappings) {
        return new MappingURITranslator(uriMappings);
    }

    public static CompositeURITranslator combine(URITranslator ... uriTranslators) {
        return new CompositeURITranslator(uriTranslators);
    }

    public static URITranslator prefix(String source, String target) {
        return new PrefixReplacer(source, target);
    }

    public static CompositeURITranslator combine(Collection<? extends URITranslator> uriTranslators) {
        return new CompositeURITranslator(uriTranslators);
    }

    public static class PrefixReplacer
    implements URITranslator {
        private final String src;
        private final String tgt;

        public PrefixReplacer(String src, String tgt) {
            this.src = src;
            this.tgt = tgt;
        }

        @Override
        public URI translate(URI original) {
            String o;
            if (null != original && (o = original.toString()).startsWith(this.src)) {
                o = this.tgt + o.substring(this.src.length());
                return URI.create(o);
            }
            return original;
        }
    }

    public static class MappingURITranslator
    implements URITranslator {
        private final Map<URI, URI> mappings = new HashMap<URI, URI>();

        public MappingURITranslator(Map<String, String> uriMappings) {
            if (null != uriMappings) {
                uriMappings.forEach((k, v) -> this.mappings.put(URI.create(k), URI.create(v)));
            }
        }

        @Override
        public URI translate(URI original) {
            return this.mappings.getOrDefault(original, original);
        }
    }

    public static class CompositeURITranslator
    extends ArrayList<URITranslator>
    implements URITranslator {
        private static final long serialVersionUID = 1L;

        public CompositeURITranslator() {
        }

        public CompositeURITranslator(URITranslator ... translators) {
            this((Collection<? extends URITranslator>)Arrays.asList(translators));
        }

        public CompositeURITranslator(Collection<? extends URITranslator> c) {
            super(c);
        }

        @Override
        public URI translate(URI original) {
            URI result = original;
            for (URITranslator translator : this) {
                result = translator.translate(result);
            }
            return result;
        }

        public CompositeURITranslator with(URITranslator translator) {
            if (null != translator) {
                return new CompositeURITranslator(this, translator);
            }
            return this;
        }
    }
}

