/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zz.com.networknt.schema.format.AbstractFormat;

public class DurationFormat
extends AbstractFormat {
    private static final Pattern STRICT = Pattern.compile("^(?:P\\d+W)|(?:P(?:\\d+Y)?(?:\\d+M)?(?:\\d+D)?(?:T(?:\\d+H)?(?:\\d+M)?(?:\\d+S)?)?)$", 2);
    private static final Pattern LAX = Pattern.compile("^(?:[-+]?)P(?:[-+]?[0-9]+Y)?(?:[-+]?[0-9]+M)?(?:[-+]?[0-9]+W)?(?:[-+]?[0-9]+D)?(?:T(?:[-+]?[0-9]+H)?(?:[-+]?[0-9]+M)?(?:[-+]?[0-9]+(?:[.,][0-9]{0,9})?S)?)?$", 2);
    private final boolean strict;

    public DurationFormat(boolean strict) {
        super("duration", "must be a valid ISO 8601 duration");
        this.strict = strict;
    }

    @Override
    public boolean matches(String duration) {
        if (null == duration) {
            return true;
        }
        if (duration.endsWith("P") || duration.endsWith("T")) {
            return false;
        }
        Pattern pattern = this.strict ? STRICT : LAX;
        Matcher matcher = pattern.matcher(duration);
        return matcher.matches();
    }
}

