/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.TypeFactory;
import zz.com.networknt.schema.UnionTypeValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.utils.JsonNodeUtil;

public class TypeValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(TypeValidator.class);
    private JsonType schemaType;
    private JsonSchema parentSchema;
    private UnionTypeValidator unionTypeValidator;

    public TypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        this.schemaType = TypeFactory.getSchemaNodeType(schemaNode);
        this.parentSchema = parentSchema;
        this.validationContext = validationContext;
        if (this.schemaType == JsonType.UNION) {
            this.unionTypeValidator = new UnionTypeValidator(schemaPath, schemaNode, parentSchema, validationContext);
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    public JsonType getSchemaType() {
        return this.schemaType;
    }

    public boolean equalsToSchemaType(JsonNode node) {
        return JsonNodeUtil.equalsToSchemaType(node, this.schemaType, this.parentSchema, this.validationContext);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        TypeValidator.debug(logger, node, rootNode, at);
        if (this.schemaType == JsonType.UNION) {
            return this.unionTypeValidator.validate(node, rootNode, at);
        }
        if (!this.equalsToSchemaType(node)) {
            JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.schemaType.toString()));
        }
        if (this.schemaPath.endsWith("/type")) {
            if (rootNode.isArray()) {
                CollectorContext.getInstance().getEvaluatedItems().add(at);
            } else if (rootNode.isObject()) {
                CollectorContext.getInstance().getEvaluatedProperties().add(at);
            }
        }
        return Collections.emptySet();
    }
}

