/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.SchemaValidatorsConfig;

public class TypeFactory {
    public static JsonType getSchemaNodeType(JsonNode node) {
        if (node.isTextual()) {
            String type = node.textValue();
            if ("object".equals(type)) {
                return JsonType.OBJECT;
            }
            if ("array".equals(type)) {
                return JsonType.ARRAY;
            }
            if ("string".equals(type)) {
                return JsonType.STRING;
            }
            if ("number".equals(type)) {
                return JsonType.NUMBER;
            }
            if ("integer".equals(type)) {
                return JsonType.INTEGER;
            }
            if ("boolean".equals(type)) {
                return JsonType.BOOLEAN;
            }
            if ("any".equals(type)) {
                return JsonType.ANY;
            }
            if ("null".equals(type)) {
                return JsonType.NULL;
            }
        }
        if (node.isArray()) {
            return JsonType.UNION;
        }
        return JsonType.UNKNOWN;
    }

    public static JsonType getValueNodeType(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isContainerNode()) {
            if (node.isObject()) {
                return JsonType.OBJECT;
            }
            if (node.isArray()) {
                return JsonType.ARRAY;
            }
            return JsonType.UNKNOWN;
        }
        if (node.isValueNode()) {
            if (node.isTextual()) {
                return JsonType.STRING;
            }
            if (node.isBinary()) {
                return JsonType.STRING;
            }
            if (node.isIntegralNumber()) {
                return JsonType.INTEGER;
            }
            if (node.isNumber()) {
                if (config != null && config.isJavaSemantics() && node.canConvertToExactIntegral()) {
                    return JsonType.INTEGER;
                }
                if (config != null && config.isLosslessNarrowing() && node.canConvertToExactIntegral()) {
                    return JsonType.INTEGER;
                }
                return JsonType.NUMBER;
            }
            if (node.isBoolean()) {
                return JsonType.BOOLEAN;
            }
            if (node.isNull()) {
                return JsonType.NULL;
            }
            return JsonType.UNKNOWN;
        }
        return JsonType.UNKNOWN;
    }
}

