/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.CustomErrorMessageType;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.JsonSchemaRef;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.uri.URIFactory;
import zz.com.networknt.schema.urn.URNFactory;

public class RefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private JsonSchema parentSchema;
    private static final String REF_CURRENT = "#";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.parentSchema = parentSchema;
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef"), new MessageFormat("{0}: Reference {1} cannot be resolved"), schemaPath, schemaPath, refValue));
        }
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        String refValueOriginal = refValue;
        JsonSchema parent = parentSchema;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            URI schemaUri = RefValidator.determineSchemaUri(validationContext.getURIFactory(), parent, refUri);
            if (schemaUri == null) {
                if (validationContext.getURNFactory() == null) {
                    return null;
                }
                schemaUri = RefValidator.determineSchemaUrn(validationContext.getURNFactory(), refUri);
                if (schemaUri == null) {
                    return null;
                }
            }
            parent = validationContext.getJsonSchemaFactory().getSchema(schemaUri, validationContext.getConfig());
            if (index < 0) {
                return new JsonSchemaRef(parent.findAncestor());
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(parent.findAncestor());
        }
        JsonNode node = parent.getRefSchemaNode(refValue);
        if (node != null) {
            JsonSchemaRef ref = validationContext.getReferenceParsingInProgress(refValueOriginal);
            if (ref == null) {
                JsonSchema schema = validationContext.newSchema(refValue, node, parent);
                ref = new JsonSchemaRef(schema);
                validationContext.setReferenceParsingInProgress(refValueOriginal, ref);
            }
            return ref;
        }
        return null;
    }

    private static URI determineSchemaUri(URIFactory uriFactory, JsonSchema parentSchema, String refUri) {
        URI schemaUri;
        URI currentUri = parentSchema.getCurrentUri();
        try {
            schemaUri = currentUri == null ? uriFactory.create(refUri) : uriFactory.create(currentUri, refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUri = null;
        }
        return schemaUri;
    }

    private static URI determineSchemaUrn(URNFactory urnFactory, String refUri) {
        URI schemaUrn;
        try {
            schemaUrn = urnFactory.create(refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUrn = null;
        }
        return schemaUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<Object> errors = new HashSet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RefValidator.debug(logger, node, rootNode, at);
            this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
            errors = this.schema != null ? this.schema.validate(node, rootNode, at) : Collections.emptySet();
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<Object> errors = new HashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            RefValidator.debug(logger, node, rootNode, at);
            this.schema.getSchema().getValidationContext().setConfig(this.parentSchema.getValidationContext().getConfig());
            if (this.schema != null) {
                errors = this.schema.walk(node, rootNode, at, shouldValidateSchema);
            }
            HashSet<ValidationMessage> hashSet = errors;
            return hashSet;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        this.schema.getSchema().initializeValidators();
    }
}

