/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.TextNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class PropertyNamesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyNamesValidator.class);
    private final JsonSchema innerSchema;

    public PropertyNamesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTYNAMES, validationContext);
        this.innerSchema = validationContext.newSchema(schemaPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        PropertyNamesValidator.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            TextNode pnameText = TextNode.valueOf(pname);
            Set<ValidationMessage> schemaErrors = this.innerSchema.validate(pnameText, node, this.atPath(at, pname));
            for (ValidationMessage schemaError : schemaErrors) {
                String path = schemaError.getPath();
                String msg = schemaError.getMessage();
                if (msg.startsWith(path)) {
                    msg = msg.substring(path.length()).replaceFirst("^:\\s*", "");
                }
                errors.add(this.buildValidationMessage(schemaError.getPath(), msg));
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        this.innerSchema.initializeValidators();
    }
}

