/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.TypeFactory;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.regex.RegularExpression;

public class PatternValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PatternValidator.class);
    private String pattern;
    private RegularExpression compiledPattern;

    public PatternValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PATTERN, validationContext);
        this.pattern = Optional.ofNullable(schemaNode).filter(JsonNode::isTextual).map(JsonNode::textValue).orElse(null);
        try {
            this.compiledPattern = RegularExpression.compile(this.pattern, validationContext);
        }
        catch (RuntimeException e) {
            e.setStackTrace(new StackTraceElement[0]);
            logger.error("Failed to compile pattern '{}': {}", (Object)this.pattern, (Object)e.getMessage());
            throw e;
        }
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    private boolean matches(String value) {
        return this.compiledPattern.matches(value);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        PatternValidator.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return Collections.emptySet();
        }
        try {
            if (!this.matches(node.asText())) {
                return Collections.singleton(this.buildValidationMessage(at, this.pattern));
            }
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("Failed to apply pattern '{}' at {}: {}", new Object[]{this.pattern, at, e.getMessage()});
            throw e;
        }
        return Collections.emptySet();
    }
}

