/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.LinkedHashSet;
import java.util.Set;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class MinMaxContainsValidator
extends BaseJsonValidator {
    private final Set<ValidationMessage> analysis = new LinkedHashSet<ValidationMessage>();

    public MinMaxContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_CONTAINS, validationContext);
        JsonNode maxNode;
        int min = 1;
        int max = Integer.MAX_VALUE;
        JsonNode minNode = parentSchema.getSchemaNode().get("minContains");
        if (null != minNode) {
            if (!minNode.isNumber() || !minNode.canConvertToExactIntegral() || minNode.intValue() < 0) {
                this.report("minContains", schemaPath);
            } else {
                min = minNode.intValue();
            }
        }
        if (null != (maxNode = parentSchema.getSchemaNode().get("maxContains"))) {
            if (!maxNode.isNumber() || !maxNode.canConvertToExactIntegral() || maxNode.intValue() < 0) {
                this.report("maxContains", schemaPath);
            } else {
                max = maxNode.intValue();
            }
        }
        if (max < min) {
            this.report("minContainsVsMaxContains", schemaPath);
        }
    }

    private void report(String messageKey, String at) {
        this.analysis.add(this.constructValidationMessage(messageKey, at, this.parentSchema.getSchemaNode().toString()));
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        return this.analysis;
    }
}

