/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.CollectorContext;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class IfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(IfValidator.class);
    private static final ArrayList<String> KEYWORDS = new ArrayList<String>(Arrays.asList("if", "then", "else"));
    private final JsonSchema ifSchema;
    private final JsonSchema thenSchema;
    private final JsonSchema elseSchema;

    public IfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.IF_THEN_ELSE, validationContext);
        JsonSchema foundIfSchema = null;
        JsonSchema foundThenSchema = null;
        JsonSchema foundElseSchema = null;
        for (String keyword : KEYWORDS) {
            JsonNode node = schemaNode.get(keyword);
            String schemaPathOfSchema = parentSchema.schemaPath + "/" + keyword;
            if (keyword.equals("if")) {
                foundIfSchema = validationContext.newSchema(schemaPathOfSchema, node, parentSchema);
                continue;
            }
            if (keyword.equals("then") && node != null) {
                foundThenSchema = validationContext.newSchema(schemaPathOfSchema, node, parentSchema);
                continue;
            }
            if (!keyword.equals("else") || node == null) continue;
            foundElseSchema = validationContext.newSchema(schemaPathOfSchema, node, parentSchema);
        }
        this.ifSchema = foundIfSchema;
        this.thenSchema = foundThenSchema;
        this.elseSchema = foundElseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        IfValidator.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        boolean ifConditionPassed = false;
        try {
            try {
                ifConditionPassed = this.ifSchema.validate(node, rootNode, at).isEmpty();
            }
            catch (JsonSchemaException ex) {
                ifConditionPassed = false;
            }
            if (ifConditionPassed && this.thenSchema != null) {
                errors.addAll(this.thenSchema.validate(node, rootNode, at));
            } else if (!ifConditionPassed && this.elseSchema != null) {
                collectorContext.exitDynamicScope();
                collectorContext.enterDynamicScope();
                errors.addAll(this.elseSchema.validate(node, rootNode, at));
            }
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.ifSchema) {
            this.ifSchema.initializeValidators();
        }
        if (null != this.thenSchema) {
            this.thenSchema.initializeValidators();
        }
        if (null != this.elseSchema) {
            this.elseSchema.initializeValidators();
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        if (null != this.ifSchema) {
            this.ifSchema.walk(node, rootNode, at, false);
        }
        if (null != this.thenSchema) {
            this.thenSchema.walk(node, rootNode, at, false);
        }
        if (null != this.elseSchema) {
            this.elseSchema.walk(node, rootNode, at, false);
        }
        return Collections.emptySet();
    }
}

