/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.Format;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonType;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.TypeFactory;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class FormatValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(FormatValidator.class);
    private final Format format;

    public FormatValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, Format format, ValidatorTypeCode type) {
        super(schemaPath, schemaNode, parentSchema, type, validationContext);
        this.format = format;
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        FormatValidator.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (this.format != null) {
            if (this.format.getName().equals("ipv6")) {
                if (!node.textValue().trim().equals(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                } else if (node.textValue().contains("%")) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            try {
                if (!this.format.matches(node.textValue())) {
                    errors.add(this.buildValidationMessage(at, this.format.getName(), this.format.getErrorMessageDescription()));
                }
            }
            catch (PatternSyntaxException pse) {
                logger.error("Failed to apply pattern on {}: Invalid RE syntax [{}]", new Object[]{at, this.format.getName(), pse});
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

