/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.networknt.schema.BaseJsonValidator;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;

public class DependentRequired
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependentRequired.class);
    private final Map<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();

    public DependentRequired(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENT_REQUIRED, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isArray()) continue;
            List dependencies = this.propertyDependencies.computeIfAbsent(pname, k -> new ArrayList());
            for (int i = 0; i < pvalue.size(); ++i) {
                dependencies.add(pvalue.get(i).asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        DependentRequired.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            List<String> dependencies = this.propertyDependencies.get(pname);
            if (dependencies == null || dependencies.isEmpty()) continue;
            for (String field : dependencies) {
                if (node.get(field) != null) continue;
                errors.add(this.buildValidationMessage(at, field, pname));
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

