/*
 * Decompiled with CFR 0.152.
 */
package zz.com.networknt.schema;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.node.ObjectNode;
import zz.com.networknt.schema.ApplyDefaultsStrategy;
import zz.com.networknt.schema.CustomErrorMessageType;
import zz.com.networknt.schema.ErrorMessageType;
import zz.com.networknt.schema.I18nSupport;
import zz.com.networknt.schema.JsonSchema;
import zz.com.networknt.schema.JsonSchemaException;
import zz.com.networknt.schema.JsonValidator;
import zz.com.networknt.schema.PathType;
import zz.com.networknt.schema.ValidationContext;
import zz.com.networknt.schema.ValidationMessage;
import zz.com.networknt.schema.ValidatorTypeCode;
import zz.com.networknt.schema.utils.StringUtils;

public abstract class BaseJsonValidator
implements JsonValidator {
    protected String schemaPath;
    protected JsonNode schemaNode;
    protected JsonSchema parentSchema;
    protected final boolean suppressSubSchemaRetrieval;
    private ValidatorTypeCode validatorType;
    private ErrorMessageType errorMessageType;
    protected ValidationContext validationContext;
    protected final boolean failFast;
    protected final ApplyDefaultsStrategy applyDefaultsStrategy;
    private final String customMessage;
    private final PathType pathType;
    private final ResourceBundle resourceBundle;

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext) {
        this(schemaPath, schemaNode, parentSchema, validatorType, validationContext, false);
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, ValidationContext validationContext, boolean suppressSubSchemaRetrieval) {
        this.errorMessageType = validatorType;
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.suppressSubSchemaRetrieval = suppressSubSchemaRetrieval;
        this.failFast = validationContext != null && validationContext.getConfig() != null && validationContext.getConfig().isFailFast();
        this.applyDefaultsStrategy = validationContext != null && validationContext.getConfig() != null && validationContext.getConfig().getApplyDefaultsStrategy() != null ? validationContext.getConfig().getApplyDefaultsStrategy() : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY;
        this.customMessage = validatorType != null ? validatorType.getCustomMessage() : null;
        this.pathType = validationContext != null && validationContext.getConfig() != null && validationContext.getConfig().getPathType() != null ? validationContext.getConfig().getPathType() : PathType.DEFAULT;
        this.resourceBundle = validationContext != null && validationContext.getConfig() != null ? validationContext.getConfig().getResourceBundle() : I18nSupport.DEFAULT_RESOURCE_BUNDLE;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    public JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema fetchSubSchemaNode(ValidationContext validationContext) {
        return this.suppressSubSchemaRetrieval ? null : BaseJsonValidator.obtainSubSchemaNode(this.schemaNode, validationContext);
    }

    private static JsonSchema obtainSubSchemaNode(JsonNode schemaNode, ValidationContext validationContext) {
        URI uri;
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals(schemaNode.get("$schema"))) {
            return null;
        }
        String text = node.textValue();
        if (text == null) {
            return null;
        }
        try {
            uri = validationContext.getURIFactory().create(node.textValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return validationContext.getJsonSchemaFactory().getSchema(uri, validationContext.getConfig());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, this.atRoot());
    }

    protected static boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected static boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected static boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual() && StringUtils.isNotBlank(errorCodeText = errorCodeNode.asText())) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        MessageFormat messageFormat = new MessageFormat(this.resourceBundle.getString(this.getErrorMessageType().getErrorCodeValue()));
        ValidationMessage message = ValidationMessage.ofWithCustom(this.getValidatorType().getValue(), this.getErrorMessageType(), messageFormat, this.customMessage, at, this.schemaPath, arguments);
        if (this.failFast && !this.isApplicator()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected ValidationMessage constructValidationMessage(String messageKey, String at, String ... arguments) {
        MessageFormat messageFormat = new MessageFormat(this.resourceBundle.getString(messageKey));
        ValidationMessage message = new ValidationMessage.Builder().code(this.getErrorMessageType().getErrorCode()).path(at).schemaPath(this.schemaPath).arguments(arguments).format(messageFormat).type(this.getValidatorType().getValue()).customMessage(this.customMessage).build();
        if (this.failFast && !this.isApplicator()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected static void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        logger.debug("validate( {}, {}, {})", new Object[]{node, rootNode, at});
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected ErrorMessageType getErrorMessageType() {
        return this.errorMessageType;
    }

    protected void updateValidatorType(ValidatorTypeCode validatorTypeCode) {
        this.validatorType = validatorTypeCode;
        this.errorMessageType = validatorTypeCode;
        this.parseErrorCode(validatorTypeCode.getErrorCodeKey());
    }

    protected String getNodeFieldType() {
        JsonNode typeField = this.getParentSchema().getSchemaNode().get("type");
        if (typeField != null) {
            return typeField.asText();
        }
        return null;
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        Set<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages = this.validate(node, rootNode, at);
        }
        return validationMessages;
    }

    protected void preloadJsonSchemas(Collection<JsonSchema> schemas) {
        for (JsonSchema schema : schemas) {
            schema.initializeValidators();
        }
    }

    private boolean isApplicator() {
        return this.isPartOfAnyOfMultipleType() || this.isPartOfIfMultipleType() || this.isPartOfNotMultipleType() || this.isPartOfOneOfMultipleType();
    }

    private boolean isPartOfAnyOfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.ANY_OF.getValue() + "/");
    }

    private boolean isPartOfIfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.IF_THEN_ELSE.getValue() + "/");
    }

    private boolean isPartOfNotMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.NOT.getValue() + "/");
    }

    protected boolean isPartOfOneOfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.ONE_OF.getValue() + "/");
    }

    protected PathType getPathType() {
        return this.pathType;
    }

    protected String atRoot() {
        return this.pathType.getRoot();
    }

    protected String atPath(String currentPath, String token) {
        return this.pathType.append(currentPath, token);
    }

    protected String atPath(String currentPath, int index) {
        return this.pathType.append(currentPath, index);
    }

    protected static void checkDiscriminatorMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, String discriminatorPropertyValue, JsonSchema jsonSchema) {
        if (discriminatorPropertyValue == null) {
            currentDiscriminatorContext.markMatch();
            return;
        }
        JsonNode discriminatorMapping = discriminator.get("mapping");
        if (null == discriminatorMapping) {
            BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
        } else {
            BaseJsonValidator.checkForExplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, discriminatorMapping, jsonSchema);
            if (!currentDiscriminatorContext.isDiscriminatorMatchFound() && BaseJsonValidator.noExplicitDiscriminatorKeyOverride(discriminatorMapping, jsonSchema)) {
                BaseJsonValidator.checkForImplicitDiscriminatorMappingMatch(currentDiscriminatorContext, discriminatorPropertyValue, jsonSchema);
            }
        }
    }

    protected static void registerAndMergeDiscriminator(ValidationContext.DiscriminatorContext currentDiscriminatorContext, ObjectNode discriminator, JsonSchema schema, String at) {
        JsonNode discriminatorOnSchema = schema.schemaNode.get("discriminator");
        if (null != discriminatorOnSchema && null != currentDiscriminatorContext.getDiscriminatorForPath(schema.schemaPath)) {
            JsonNode propertyName = discriminatorOnSchema.get("propertyName");
            if (null != propertyName) {
                throw new JsonSchemaException(at + " schema " + schema + " attempts redefining the discriminator property");
            }
            ObjectNode mappingOnContextDiscriminator = (ObjectNode)discriminator.get("mapping");
            ObjectNode mappingOnCurrentSchemaDiscriminator = (ObjectNode)discriminatorOnSchema.get("mapping");
            if (null == mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                discriminator.set("mapping", discriminatorOnSchema);
            } else if (null != mappingOnContextDiscriminator && null != mappingOnCurrentSchemaDiscriminator) {
                Iterator<Map.Entry<String, JsonNode>> fieldsToAdd = mappingOnCurrentSchemaDiscriminator.fields();
                while (fieldsToAdd.hasNext()) {
                    Map.Entry<String, JsonNode> fieldToAdd = fieldsToAdd.next();
                    String mappingKeyToAdd = fieldToAdd.getKey();
                    JsonNode mappingValueToAdd = fieldToAdd.getValue();
                    JsonNode currentMappingValue = mappingOnContextDiscriminator.get(mappingKeyToAdd);
                    if (null != currentMappingValue && currentMappingValue != mappingValueToAdd) {
                        throw new JsonSchemaException(at + "discriminator mapping redefinition from " + mappingKeyToAdd + "/" + currentMappingValue + " to " + mappingValueToAdd);
                    }
                    if (null != currentMappingValue) continue;
                    mappingOnContextDiscriminator.set(mappingKeyToAdd, mappingValueToAdd);
                }
            }
        }
        currentDiscriminatorContext.registerDiscriminator(schema.schemaPath, discriminator);
    }

    private static void checkForImplicitDiscriminatorMappingMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonSchema schema) {
        if (schema.schemaPath.endsWith("/" + discriminatorPropertyValue)) {
            currentDiscriminatorContext.markMatch();
        }
    }

    private static void checkForExplicitDiscriminatorMappingMatch(ValidationContext.DiscriminatorContext currentDiscriminatorContext, String discriminatorPropertyValue, JsonNode discriminatorMapping, JsonSchema schema) {
        Iterator<Map.Entry<String, JsonNode>> explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry<String, JsonNode> candidateExplicitMapping = explicitMappings.next();
            if (!candidateExplicitMapping.getKey().equals(discriminatorPropertyValue) || !schema.schemaPath.equals(candidateExplicitMapping.getValue().asText())) continue;
            currentDiscriminatorContext.markMatch();
            break;
        }
    }

    private static boolean noExplicitDiscriminatorKeyOverride(JsonNode discriminatorMapping, JsonSchema parentSchema) {
        Iterator<Map.Entry<String, JsonNode>> explicitMappings = discriminatorMapping.fields();
        while (explicitMappings.hasNext()) {
            Map.Entry<String, JsonNode> candidateExplicitMapping = explicitMappings.next();
            if (!candidateExplicitMapping.getValue().asText().equals(parentSchema.schemaPath)) continue;
            return false;
        }
        return true;
    }
}

