/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.git.utils.repository;

import com.sonatype.nexus.git.utils.api.GitException;
import com.sonatype.nexus.git.utils.common.BaseJGitFinder;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.eclipse.jgit.api.Git;
import zz.org.eclipse.jgit.api.LogCommand;
import zz.org.eclipse.jgit.lib.PersonIdent;
import zz.org.eclipse.jgit.lib.Ref;
import zz.org.eclipse.jgit.lib.RefDatabase;
import zz.org.eclipse.jgit.lib.Repository;
import zz.org.eclipse.jgit.revwalk.RevCommit;
import zz.org.eclipse.jgit.revwalk.RevTag;
import zz.org.eclipse.jgit.revwalk.RevWalk;
import zz.org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;

public class JGitRecentCommitterFinder
extends BaseJGitFinder {
    private static final Logger log = LoggerFactory.getLogger(JGitRecentCommitterFinder.class);
    private String repositoryPath;
    private final int daysPeriod;

    public JGitRecentCommitterFinder(String repositoryPath, int daysPeriod) {
        this.repositoryPath = repositoryPath;
        this.daysPeriod = daysPeriod;
    }

    public JGitRecentCommitterFinder(int daysPeriod) {
        this.daysPeriod = daysPeriod;
    }

    public Map<String, Collection<Instant>> tryGetRecentCommitters() throws GitException {
        HashMap<String, Collection<Instant>> recentCommittersMap = new HashMap<String, Collection<Instant>>();
        Instant periodAgo = Instant.now().minus(this.daysPeriod, ChronoUnit.DAYS);
        Consumer<PersonIdent> addToCommittersMap = personIdent -> {
            String email = personIdent.getEmailAddress();
            if (StringUtils.isNotBlank(email)) {
                Instant timestamp = personIdent.getWhen().toInstant();
                recentCommittersMap.computeIfAbsent(email, k -> new HashSet()).add(timestamp);
            } else {
                log.debug("Found PersonIdent with a missing email: {}", personIdent);
            }
        };
        try (Repository repository = null;){
            try {
                repository = this.getJGitRepository(this.repositoryPath);
                this.forCommitAuthorsAndCommitters(repository, periodAgo, addToCommittersMap);
                this.forTaggers(repository, periodAgo, addToCommittersMap);
            }
            catch (Exception e) {
                throw new GitException("Failed to get all committers, authors, and/or taggers", e);
            }
        }
        return recentCommittersMap;
    }

    private void forCommitAuthorsAndCommitters(Repository repository, Instant since, Consumer<PersonIdent> consumer) throws GitException {
        try {
            LogCommand command = new Git(repository).log().all().setRevFilter(CommitTimeRevFilter.after(Date.from(since)));
            Iterator iterator = command.call().iterator();
            while (iterator.hasNext()) {
                RevCommit commit = (RevCommit)iterator.next();
                PersonIdent author = commit.getAuthorIdent();
                PersonIdent committer = commit.getCommitterIdent();
                consumer.accept(committer);
                if (!this.isAfter(author, since)) continue;
                consumer.accept(author);
            }
        }
        catch (Exception e) {
            throw new GitException("An error occurred while processing commits", e);
        }
    }

    private void forTaggers(Repository repository, Instant since, Consumer<PersonIdent> consumer) throws GitException {
        try {
            Object tagRefs = new Git(repository).tagList().call();
            RevWalk revWalk = new RevWalk(repository);
            RefDatabase refDb = repository.getRefDatabase();
            Iterator iterator = tagRefs.iterator();
            while (iterator.hasNext()) {
                RevTag tag;
                PersonIdent tagger;
                Ref ref = (Ref)iterator.next();
                Ref peeledRef = refDb.peel(ref);
                if (peeledRef.getPeeledObjectId() == null || !this.isAfter(tagger = (tag = revWalk.parseTag(peeledRef.getObjectId())).getTaggerIdent(), since)) continue;
                consumer.accept(tagger);
            }
        }
        catch (Exception e) {
            throw new GitException("An error occurred while processing taggers", e);
        }
    }

    private boolean isAfter(PersonIdent ident, Instant timeToBeAfter) {
        return ident.getWhen().toInstant().isAfter(timeToBeAfter);
    }
}

