/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.model.Property;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.BaseCodeVisitor;
import zz.org.codehaus.groovy.ast.expr.BinaryExpression;
import zz.org.codehaus.groovy.ast.expr.ConstantExpression;
import zz.org.codehaus.groovy.ast.expr.DeclarationExpression;
import zz.org.codehaus.groovy.ast.expr.Expression;
import zz.org.codehaus.groovy.ast.expr.GStringExpression;

public class PropertyVisitor
extends BaseCodeVisitor {
    public PropertyVisitor(BuildModel model) {
        super(model);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.processBinaryExpression((BinaryExpression)expression);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        this.processBinaryExpression(expression);
    }

    private void processBinaryExpression(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        Expression rightExpression = expression.getRightExpression();
        if (expression.getOperation().getText().equals("=") && (rightExpression instanceof ConstantExpression || rightExpression instanceof GStringExpression)) {
            String name = leftExpression.getText();
            if (name.startsWith("ext.")) {
                name = name.substring(4);
            }
            Property property = new Property(this.model).setName(name).setValue(rightExpression.getText()).setCallPath(this.getPropertyCallPath());
            property.setLineNumber(expression.getLineNumber()).setColumnNumber(expression.getColumnNumber()).setLastLineNumber(expression.getLastLineNumber()).setLastColumnNumber(expression.getLastColumnNumber());
            this.model.addProperty(property);
        }
    }
}

