/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.archive.TFileUtils;
import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.ConfigurationVisitor;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.DependencyVisitor;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.PropertyVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.io.IOUtils;
import zz.org.codehaus.groovy.ast.ASTNode;
import zz.org.codehaus.groovy.ast.ClassNode;
import zz.org.codehaus.groovy.ast.GroovyCodeVisitor;
import zz.org.codehaus.groovy.ast.builder.AstBuilder;
import zz.org.codehaus.groovy.control.CompilePhase;

public class GroovyBuildFileReader {
    public BuildModel read(Path filePath) throws IOException {
        byte[] encoded = Files.readAllBytes(filePath);
        String codeAsText = new String(encoded, StandardCharsets.UTF_8);
        return this.buildAstAndPopulateModel(filePath.toFile(), codeAsText);
    }

    public BuildModel read(TFile file) throws IOException {
        try (InputStream fileInputStream = TFileUtils.openInputStream(file);){
            String codeAsText = IOUtils.toString(fileInputStream, StandardCharsets.UTF_8);
            BuildModel buildModel = this.buildAstAndPopulateModel(file, codeAsText);
            return buildModel;
        }
    }

    private BuildModel buildAstAndPopulateModel(File buildFile, String codeAsText) {
        BuildModel model = new BuildModel();
        model.setBuildFile(buildFile);
        AstBuilder builder = new AstBuilder();
        List astNodes = builder.buildFromString(CompilePhase.CONVERSION, codeAsText);
        this.collectConfigurations(model, astNodes);
        this.collectDependencies(model, astNodes);
        this.collectProperties(model, astNodes);
        return model;
    }

    private void collectConfigurations(BuildModel model, List<ASTNode> astNodes) {
        ConfigurationVisitor configurationVisitor = new ConfigurationVisitor(model);
        this.walkTree(astNodes, (GroovyCodeVisitor)configurationVisitor);
        configurationVisitor.collectCompileScopeConfigurations();
    }

    private void collectProperties(BuildModel model, List<ASTNode> astNodes) {
        PropertyVisitor propertyVisitor = new PropertyVisitor(model);
        this.walkTree(astNodes, (GroovyCodeVisitor)propertyVisitor);
    }

    private void collectDependencies(BuildModel model, List<ASTNode> astNodes) {
        DependencyVisitor dependenciesVisitor = new DependencyVisitor(model);
        this.walkTree(astNodes, (GroovyCodeVisitor)dependenciesVisitor);
    }

    private void walkTree(List<ASTNode> nodes, GroovyCodeVisitor visitor) {
        for (ASTNode node : nodes) {
            if (node instanceof ClassNode) continue;
            node.visit(visitor);
        }
    }
}

