/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import com.sonatype.insight.scan.tools.manifests.gradle.parser.BaseCodeVisitor;
import java.util.List;
import zz.org.codehaus.groovy.ast.expr.ArgumentListExpression;
import zz.org.codehaus.groovy.ast.expr.Expression;
import zz.org.codehaus.groovy.ast.expr.MethodCallExpression;
import zz.org.codehaus.groovy.ast.expr.VariableExpression;

public class ConfigurationVisitor
extends BaseCodeVisitor {
    private String[] javaCompileConfigurations = new String[]{"api", "apiElements", "compileClasspath", "implementation", "compileOnly", "compileOnlyApi", "compile"};

    public ConfigurationVisitor(BuildModel model) {
        super(model);
    }

    @Override
    public void childVisitMethodCallExpression(MethodCallExpression methodCallExpression) {
        Expression objectExpression;
        String method;
        if (this.isInConfigurations() && "extendsFrom".equals(method = methodCallExpression.getMethod().getText()) && (objectExpression = methodCallExpression.getObjectExpression()) instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)objectExpression;
            String variable = variableExpression.getName();
            Expression arguments = methodCallExpression.getArguments();
            if (arguments instanceof ArgumentListExpression) {
                ArgumentListExpression ale = (ArgumentListExpression)arguments;
                for (Expression expression : ale) {
                    if (!(expression instanceof VariableExpression)) continue;
                    VariableExpression varExpression = (VariableExpression)expression;
                    String value = varExpression.getName();
                    this.model.addConfigurationMapping(variable, value);
                }
            }
        }
    }

    public void collectCompileScopeConfigurations() {
        for (String compileConfiguration : this.javaCompileConfigurations) {
            this.model.addCompileScopeConfiguration(compileConfiguration);
            this.addParentConfigurations(compileConfiguration);
        }
    }

    private void addParentConfigurations(String configName) {
        if (this.model.getConfigurationMap().containsKey(configName)) {
            List<String> names = this.model.getConfigurationMap().get(configName);
            for (String name : names) {
                this.model.addCompileScopeConfiguration(name);
                this.addParentConfigurations(name);
            }
        }
    }
}

