/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.tools.manifests.gradle.parser;

import com.sonatype.insight.scan.tools.manifests.gradle.model.BuildModel;
import java.util.Deque;
import java.util.LinkedList;
import zz.org.codehaus.groovy.ast.CodeVisitorSupport;
import zz.org.codehaus.groovy.ast.expr.MethodCallExpression;

public abstract class BaseCodeVisitor
extends CodeVisitorSupport {
    protected final BuildModel model;
    private final Deque<String> methodStack = new LinkedList<String>();

    public BaseCodeVisitor(BuildModel model) {
        this.model = model;
    }

    public void visitMethodCallExpression(MethodCallExpression methodCallExpression) {
        String method = methodCallExpression.getMethod().getText();
        this.addToMethodStack(method);
        this.childVisitMethodCallExpression(methodCallExpression);
        super.visitMethodCallExpression(methodCallExpression);
        this.removeFromMethodStack();
    }

    protected void childVisitMethodCallExpression(MethodCallExpression methodCallExpression) {
    }

    protected String getPropertyCallPath() {
        String scope = String.join((CharSequence)".", this.methodStack);
        if (scope.equals("ext")) {
            return "";
        }
        int lastIndex = scope.lastIndexOf(".ext");
        if (lastIndex > -1) {
            scope = scope.substring(0, lastIndex);
        }
        return scope;
    }

    protected String getDependencyCallPath() {
        String head = this.removeFromMethodStack();
        String scope = String.join((CharSequence)".", this.methodStack);
        this.addToMethodStack(head);
        return scope;
    }

    protected void addToMethodStack(String method) {
        this.methodStack.addLast(method);
    }

    protected String removeFromMethodStack() {
        return this.methodStack.removeLast();
    }

    protected String getHeadOfMethodStack() {
        return this.methodStack.getLast();
    }

    protected boolean isInDependencies() {
        return this.methodStack.contains("dependencies");
    }

    protected boolean isInArtifact() {
        return this.methodStack.contains("artifact");
    }

    protected boolean isInVersion() {
        return this.methodStack.contains("version");
    }

    protected boolean isFileDependency() {
        return this.isInDependencies() && ("files".equals(this.methodStack.getLast()) || "fileTree".equals(this.methodStack.getLast()));
    }

    protected boolean isProjectDependency() {
        return this.isInDependencies() && "project".equals(this.methodStack.getLast());
    }

    protected boolean isInExcludeClause() {
        return this.methodStack.contains("exclude");
    }

    protected boolean isInConfigurations() {
        return this.methodStack.contains("configurations");
    }
}

