/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.NpmManifestFileReader;
import com.sonatype.insight.scan.file.YarnLockFileReaderV1;
import com.sonatype.insight.scan.file.YarnLockFileReaderV2;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.fasterxml.jackson.databind.JsonNode;
import zz.com.fasterxml.jackson.databind.ObjectMapper;
import zz.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;

class YarnReaderFactory {
    private static final Logger log = LoggerFactory.getLogger(YarnReaderFactory.class);

    YarnReaderFactory() {
    }

    static NpmManifestFileReader getInstance(TFile file) {
        List<String> lines = FileUtils.readLines(file);
        String content = StringUtils.join(lines, '\n');
        JsonNode jsonNode = null;
        if (!content.contains("# yarn lockfile v1")) {
            try {
                jsonNode = new ObjectMapper(new YAMLFactory()).readTree(content);
            }
            catch (IOException e) {
                log.debug("Failed to process yarn.lock file as yaml.", (Throwable)e);
            }
        }
        if (jsonNode == null) {
            return new YarnLockFileReaderV1(lines);
        }
        return new YarnLockFileReaderV2(jsonNode);
    }
}

