/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.InvalidSbomException;
import com.sonatype.insight.scan.file.UnsupportedSbomException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.BomParserFactory;
import zz.org.cyclonedx.CycloneDxSchema;
import zz.org.cyclonedx.exception.ParseException;
import zz.org.cyclonedx.model.Bom;
import zz.org.cyclonedx.parsers.Parser;
import zz.org.spdx.jacksonstore.MultiFormatStore;
import zz.org.spdx.library.DefaultModelStore;
import zz.org.spdx.library.InvalidSPDXAnalysisException;
import zz.org.spdx.library.model.SpdxDocument;
import zz.org.spdx.storage.simple.InMemSpdxStore;

public final class ThirdPartyUtils {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyUtils.class);
    public static final Map<String, CycloneDxSchema.Version> CYCLONEDX_ACCEPTED_VERSIONS_XML = new HashMap<String, CycloneDxSchema.Version>();
    public static final Map<String, CycloneDxSchema.Version> CYCLONEDX_ACCEPTED_VERSIONS_JSON = new HashMap<String, CycloneDxSchema.Version>();
    public static final Map<String, String> SPDX_ACCEPTED_VERSIONS = new HashMap<String, String>();
    private static final Pattern DEPRECATION_PATTERN;

    public static Bom parseAndValidateCycloneDx(String content, SbomFormat format) throws InvalidSbomException, ParseException, IOException, UnsupportedSbomException {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        Parser parser = BomParserFactory.createParser(bytes);
        Bom bom = parser.parse(bytes);
        ThirdPartyUtils.validateCycloneDxVersion(format, bom);
        CycloneDxSchema.Version schemaVersion = ThirdPartyUtils.getCycloneDxSchemaVersion(bom.getSpecVersion());
        ThirdPartyUtils.validateCycloneDx(schemaVersion, parser, bytes);
        return bom;
    }

    private static void validateCycloneDx(CycloneDxSchema.Version schemaVersion, Parser parser, byte[] bytes) throws IOException {
        List<ParseException> validate = parser.validate(bytes, schemaVersion);
        if (!validate.isEmpty()) {
            InvalidSbomException invalidSbomException = new InvalidSbomException("The sbom is not valid.");
            validate.forEach(invalidSbomException::addSuppressed);
            log.error(invalidSbomException.getMessage() + " There were " + invalidSbomException.getSuppressed().length + " errors.", (Throwable)invalidSbomException);
            throw invalidSbomException;
        }
    }

    public static CycloneDxSchema.Version getCycloneDxSchemaVersion(String versionBom) {
        for (CycloneDxSchema.Version version : CycloneDxSchema.Version.values()) {
            if (!version.getVersionString().equals(versionBom)) continue;
            return version;
        }
        return null;
    }

    public static SpdxDocument parseAndValidateSpdx(String content, SbomFormat sbomFormat) throws InvalidSPDXAnalysisException, InvalidSbomException, IOException, UnsupportedSbomException {
        String uri;
        MultiFormatStore.Format format = sbomFormat == SbomFormat.JSON ? MultiFormatStore.Format.JSON : MultiFormatStore.Format.XML;
        DefaultModelStore.reset();
        InMemSpdxStore modelStore = new InMemSpdxStore();
        try (MultiFormatStore multiFormatStore = new MultiFormatStore(modelStore, format, MultiFormatStore.Verbose.COMPACT);
             BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(content.getBytes()));){
            uri = multiFormatStore.deSerialize(in, true);
        }
        catch (Exception e) {
            throw new IOException("SPDX content cannot be parsed", e);
        }
        SpdxDocument spdxDocument = new SpdxDocument(modelStore, uri, DefaultModelStore.getDefaultCopyManager(), true);
        ThirdPartyUtils.validateSpdxVersion(sbomFormat, spdxDocument);
        ThirdPartyUtils.validateSpdx(spdxDocument);
        return spdxDocument;
    }

    private static void validateSpdx(SpdxDocument spdxDocument) {
        List<String> verificationErrors = spdxDocument.verify().stream().filter(s -> !DEPRECATION_PATTERN.matcher((CharSequence)s).matches()).collect(Collectors.toList());
        if (!verificationErrors.isEmpty()) {
            InvalidSbomException invalidSbomException = new InvalidSbomException("The sbom is not valid.");
            verificationErrors.forEach(ve -> invalidSbomException.addSuppressed(new InvalidSPDXAnalysisException(ve.replace("Relationship error: ", ""))));
            log.error(invalidSbomException.getMessage() + " There were " + verificationErrors.size() + " errors.", (Throwable)invalidSbomException);
            throw invalidSbomException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateCycloneDxVersion(SbomFormat format, Bom bom) throws UnsupportedSbomException {
        if (format == null) throw new UnsupportedSbomException("Missing CycloneDX encoding type");
        String schemaVersion = bom.getSpecVersion();
        if (format == SbomFormat.XML) {
            CycloneDxSchema.Version version = CYCLONEDX_ACCEPTED_VERSIONS_XML.get(schemaVersion);
            if (version != null) return;
            throw new UnsupportedSbomException("CycloneDX XML " + schemaVersion + " version is not supported");
        }
        if (format != SbomFormat.JSON) throw new UnsupportedSbomException("CycloneDX content encodingType (" + (Object)((Object)format) + ") is not supported");
        CycloneDxSchema.Version version = CYCLONEDX_ACCEPTED_VERSIONS_JSON.get(schemaVersion);
        if (version != null) return;
        throw new UnsupportedSbomException("CycloneDX JSON " + schemaVersion + " version is not supported");
    }

    public static void validateSpdxVersion(SbomFormat format, SpdxDocument spdxDocument) throws UnsupportedSbomException {
        block5: {
            if (format != null) {
                try {
                    String specVersion = spdxDocument.getSpecVersion();
                    if (StringUtils.isBlank(specVersion)) {
                        throw new UnsupportedSbomException("SPDX version is not specified");
                    }
                    if (!SPDX_ACCEPTED_VERSIONS.containsKey(specVersion)) {
                        throw new UnsupportedSbomException("SPDX " + specVersion.replace("SPDX-", "") + " version is not supported");
                    }
                    break block5;
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new UnsupportedSbomException("SPDX version is not specified");
                }
            }
            throw new UnsupportedSbomException("Missing SPDX encoding type");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSbomContent(TFile file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            StringBuilder buffer = new StringBuilder();
            String line = reader.readLine();
            while (line != null && buffer.length() < 8192) {
                buffer.append(line);
                line = reader.readLine();
            }
            boolean bl = ThirdPartyUtils.looksLikeCycloneDX(buffer.toString());
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean looksLikeCycloneDX(String bomString) {
        if (bomString.contains("<bom") && bomString.contains("http://cyclonedx.org/schema/bom")) {
            return true;
        }
        return bomString.startsWith("{") && bomString.contains("bomFormat") && bomString.contains("CycloneDX");
    }

    static {
        CYCLONEDX_ACCEPTED_VERSIONS_XML.put(CycloneDxSchema.Version.VERSION_11.getVersionString(), CycloneDxSchema.Version.VERSION_11);
        CYCLONEDX_ACCEPTED_VERSIONS_XML.put(CycloneDxSchema.Version.VERSION_12.getVersionString(), CycloneDxSchema.Version.VERSION_12);
        CYCLONEDX_ACCEPTED_VERSIONS_XML.put(CycloneDxSchema.Version.VERSION_13.getVersionString(), CycloneDxSchema.Version.VERSION_13);
        CYCLONEDX_ACCEPTED_VERSIONS_XML.put(CycloneDxSchema.Version.VERSION_14.getVersionString(), CycloneDxSchema.Version.VERSION_14);
        CYCLONEDX_ACCEPTED_VERSIONS_XML.put(CycloneDxSchema.Version.VERSION_15.getVersionString(), CycloneDxSchema.Version.VERSION_15);
        CYCLONEDX_ACCEPTED_VERSIONS_JSON.put(CycloneDxSchema.Version.VERSION_14.getVersionString(), CycloneDxSchema.Version.VERSION_14);
        CYCLONEDX_ACCEPTED_VERSIONS_JSON.put(CycloneDxSchema.Version.VERSION_15.getVersionString(), CycloneDxSchema.Version.VERSION_15);
        SPDX_ACCEPTED_VERSIONS.put("SPDX-2.3", "2.3");
        DEPRECATION_PATTERN = Pattern.compile(".*Relationship error: [^\\s]+ is deprecated\\..*");
    }

    public static enum SbomFormat {
        XML,
        JSON;

    }
}

