/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.file.PoetryFile;
import com.sonatype.insight.scan.file.SbomUtils;
import com.sonatype.insight.scan.manifest.PoetryPackage;
import com.sonatype.insight.scan.model.ItemContentType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.cyclonedx.exception.GeneratorException;
import zz.org.cyclonedx.model.Component;

public class PoetryLockProcessor {
    static final String POETRY_COORDINATE_NAME = "name";
    static final String POETRY_COORDINATE_VERSION = "version";
    static final String POETRY_COORDINATE_QUALIFIER = "qualifier";
    static final String POETRY_COORDINATE_EXTENSION = "extension";
    private final Logger log = LoggerFactory.getLogger(PoetryLockProcessor.class);
    private final FileVisitor fileVisitor;

    public PoetryLockProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
    }

    public String process(TFile file) {
        try {
            this.log.debug("Processing poetry lock file: {}", (Object)file.getAbsolutePath());
            PoetryFile poetryFile = PoetryFile.fromFileContents(file);
            LinkedHashSet<Component> components = new LinkedHashSet<Component>();
            for (PoetryPackage poetryPackage : poetryFile.getPoetryPackages()) {
                if (!this.isValidPackage(poetryPackage) || !this.isNotSensitiveContent(poetryPackage)) continue;
                this.mapToBomComponent(poetryPackage, components);
            }
            return SbomUtils.createSbomXmlString(new ArrayList<Component>(components));
        }
        catch (IOException | ParserConfigurationException | MalformedPackageURLException | GeneratorException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isNotSensitiveContent(PoetryPackage poetryPackage) {
        return this.fileVisitor.includeResourceName(poetryPackage.getName());
    }

    private boolean isValidPackage(PoetryPackage poetryPackage) {
        return StringUtils.isNotBlank(poetryPackage.getName()) && StringUtils.isNotBlank(poetryPackage.getVersion());
    }

    private void mapToBomComponent(PoetryPackage poetryPackage, Set<Component> components) throws MalformedPackageURLException {
        Component component = this.createBomComponent(poetryPackage);
        for (PoetryPackage child : poetryPackage.getPoetryPackages()) {
            component.addComponent(this.createBomComponent(child));
        }
        components.add(component);
    }

    private Component createBomComponent(PoetryPackage poetryPackage) throws MalformedPackageURLException {
        Component component = SbomUtils.createLibraryComponent(poetryPackage.getName(), poetryPackage.getVersion());
        PackageURLBuilder packageURLBuilder = PackageURLBuilder.aPackageURL().withType(ItemContentType.POETRY_LOCK.format).withName(component.getName()).withVersion(component.getVersion());
        if (StringUtils.isNotBlank(poetryPackage.getExtension())) {
            packageURLBuilder.withQualifier(POETRY_COORDINATE_EXTENSION, poetryPackage.getExtension());
        }
        if (StringUtils.isNotBlank(poetryPackage.getQualifier())) {
            packageURLBuilder.withQualifier(POETRY_COORDINATE_QUALIFIER, poetryPackage.getQualifier());
        }
        component.setPurl(packageURLBuilder.build().canonicalize());
        return component;
    }
}

