/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.manifest.PoetryPackage;
import com.sonatype.insight.scan.model.ItemContentType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zz.com.github.packageurl.MalformedPackageURLException;
import zz.com.github.packageurl.PackageURLBuilder;
import zz.de.schlichtherle.truezip.file.TFile;
import zz.de.schlichtherle.truezip.file.TFileInputStream;
import zz.org.apache.commons.lang3.StringUtils;
import zz.org.tomlj.Toml;
import zz.org.tomlj.TomlArray;
import zz.org.tomlj.TomlParseResult;
import zz.org.tomlj.TomlTable;

public class PoetryFile {
    private static final Pattern METADATA_PACKAGE_PATTERN = Pattern.compile("(?<name>^(.*?))([-])((?<version>([0-9a-zA-Z]*[\\.]?){1,3})([-])?(?<buildTag>[-][0-9][\\w]*)?)([-])?(?<qualifier>(py2.py3|[\\w]*)[-][\\w]*[-][\\w]*)?([.])(?<extension>(tar\\.gz|tar\\.bz2|zip|exe|egg|msi|rpm|tgz|dmg|deb|whl)$)");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([A-Za-z0-9_.!+])");
    private static final String DEV_CATEGORY = "dev";
    private final Logger log = LoggerFactory.getLogger(PoetryFile.class);
    private final Map<String, Set<PoetryPackage>> poetryMapPackages = new HashMap<String, Set<PoetryPackage>>();
    private final Map<String, PoetryPackage> poetryDependenciesMapPackages = new HashMap<String, PoetryPackage>();
    private final Set<String> resolvedDependencies = new HashSet<String>();

    public static PoetryFile fromFileContents(TFile file) throws IOException {
        return new PoetryFile(file);
    }

    private PoetryFile(TFile file) throws IOException {
        File pyprojectToml;
        String folder = file.getParent();
        if (folder != null && (pyprojectToml = Paths.get(folder, "pyproject.toml").toFile()).isFile()) {
            this.resolveProductionDependencies(file, pyprojectToml);
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(file), StandardCharsets.UTF_8);){
            TomlParseResult parseResult = Toml.parse(reader);
            this.createPoetryPackages(parseResult);
            if (!this.poetryMapPackages.isEmpty()) {
                TomlTable metadata = parseResult.getTableOrEmpty("metadata");
                TomlTable files = metadata.getTableOrEmpty("files");
                for (String packageName : files.dottedKeySet()) {
                    TomlArray packageFiles = files.getArrayOrEmpty(packageName);
                    for (int i = 0; i < packageFiles.size(); ++i) {
                        String fileValue = packageFiles.getTable(i).getString("file");
                        this.processPoetryPackageFromMetadata(fileValue);
                    }
                }
            }
        }
    }

    private void createPoetryPackages(TomlParseResult parseResult) {
        TomlArray packages = parseResult.getArrayOrEmpty("package");
        for (int i = 0; i < packages.size(); ++i) {
            TomlTable packageCoordinates = packages.getTable(i);
            String name = packageCoordinates.getString("name");
            String version = packageCoordinates.getString("version");
            String category = packageCoordinates.getString("category");
            if ((this.resolvedDependencies.isEmpty() || !this.resolvedDependencies.contains(name)) && (!this.resolvedDependencies.isEmpty() || !StringUtils.isNoneBlank(name, version) || DEV_CATEGORY.equals(category))) continue;
            PoetryPackage poetryPackage = new PoetryPackage(name, version);
            String purl = this.getPurl(name, version);
            if (purl == null) continue;
            this.addPackageToMap(poetryPackage, this.poetryMapPackages, purl);
            TomlTable dependencies = packageCoordinates.getTableOrEmpty("dependencies");
            this.createPoetryPackageDependencies(dependencies, purl);
        }
    }

    private void createPoetryPackageDependencies(TomlTable dependencies, String parentPurl) {
        for (Map.Entry<String, Object> entry : dependencies.toMap().entrySet()) {
            for (String version : this.getVersions(entry.getValue())) {
                this.poetryPackageFromString(entry.getKey(), version, parentPurl);
            }
        }
    }

    private Set<String> getVersions(Object value) {
        HashSet<String> versions = new HashSet<String>();
        if (value instanceof String) {
            versions.add((String)value);
        } else if (value instanceof TomlTable) {
            versions.add(((TomlTable)value).getString("version"));
        } else if (value instanceof TomlArray) {
            TomlArray array = (TomlArray)value;
            for (int i = 0; i < array.size(); ++i) {
                versions.addAll(this.getVersions(array.get(i)));
            }
        } else {
            this.log.debug("Unrecognized dependency entry value " + value + ".");
        }
        return versions;
    }

    private void poetryPackageFromString(String name, String version, String parentPurl) {
        Matcher matcher;
        if (StringUtils.isNoneBlank(version) && (matcher = VERSION_PATTERN.matcher(version)).find()) {
            PoetryPackage dependencyPackage = new PoetryPackage(name, version);
            this.addDependencyToMap(dependencyPackage, parentPurl);
        }
    }

    private void addDependencyToMap(PoetryPackage dependencyPackage, String parentPurl) {
        String purl = this.getPurl(dependencyPackage.getName(), dependencyPackage.getVersion());
        if (purl != null) {
            PoetryPackage poetryPackage = this.poetryDependenciesMapPackages.computeIfAbsent(purl, k -> dependencyPackage);
            poetryPackage.getParentsPurl().add(parentPurl);
        }
    }

    private void processPoetryPackageFromMetadata(String fileValue) {
        Matcher matcher = METADATA_PACKAGE_PATTERN.matcher(fileValue);
        if (matcher.find()) {
            String name = matcher.group("name");
            String version = matcher.group("version");
            if (StringUtils.isNotBlank(matcher.group("buildTag"))) {
                version = version + matcher.group("buildTag");
            }
            String qualifier = matcher.group("qualifier");
            String extension = matcher.group("extension");
            String purl = this.getPurl(name, version);
            if (purl != null) {
                Set<PoetryPackage> poetryPackagesByPurl = this.poetryMapPackages.get(purl);
                if (poetryPackagesByPurl != null) {
                    this.handlePackageMetadata(name, version, qualifier, extension, poetryPackagesByPurl);
                }
                PoetryPackage dependencyPackage = this.poetryDependenciesMapPackages.get(purl);
                this.handleDependencyMetadata(name, version, qualifier, extension, dependencyPackage);
            }
        }
    }

    private void handlePackageMetadata(String name, String version, String qualifier, String extension, Set<PoetryPackage> poetryPackagesByPurl) {
        PoetryPackage packageByQualifierAndExtension = this.findPackageByQualifierAndExtension(poetryPackagesByPurl, qualifier, extension);
        if (packageByQualifierAndExtension == null) {
            PoetryPackage packageByEmptyQualifierAndExtension = this.findPackageByEmptyQualifierAndExtension(poetryPackagesByPurl);
            if (packageByEmptyQualifierAndExtension != null) {
                packageByEmptyQualifierAndExtension.setQualifier(qualifier);
                packageByEmptyQualifierAndExtension.setExtension(extension);
            } else {
                PoetryPackage poetryPackage = new PoetryPackage(name, version, qualifier, extension);
                poetryPackagesByPurl.add(poetryPackage);
            }
        }
    }

    private void handleDependencyMetadata(String name, String version, String qualifier, String extension, PoetryPackage dependencyPackage) {
        if (dependencyPackage != null) {
            if (StringUtils.isAllBlank(dependencyPackage.getQualifier(), dependencyPackage.getExtension())) {
                dependencyPackage.setQualifier(qualifier);
                dependencyPackage.setExtension(extension);
                this.addDependenciesToParent(dependencyPackage.getParentsPurl(), dependencyPackage);
            } else {
                this.addDependenciesToParent(dependencyPackage.getParentsPurl(), new PoetryPackage(name, version, qualifier, extension));
            }
        }
    }

    private void addDependenciesToParent(Set<String> parentsPurl, PoetryPackage poetryPackage) {
        parentsPurl.forEach(parentPurl -> {
            Set<PoetryPackage> parentPackages = this.poetryMapPackages.get(parentPurl);
            parentPackages.forEach(parentPackage -> parentPackage.getPoetryPackages().add(poetryPackage));
        });
    }

    private void addPackageToMap(PoetryPackage poetryPackage, Map<String, Set<PoetryPackage>> map, String purl) {
        Set poetryPackages = map.getOrDefault(purl, new HashSet());
        poetryPackages.add(poetryPackage);
        map.put(purl, poetryPackages);
    }

    private PoetryPackage findPackageByQualifierAndExtension(Set<PoetryPackage> poetryPackages, String qualifier, String extension) {
        return poetryPackages.stream().filter(poetryPackage -> qualifier != null && qualifier.equals(poetryPackage.getQualifier()) && extension != null && extension.equals(poetryPackage.getExtension())).findFirst().orElse(null);
    }

    private PoetryPackage findPackageByEmptyQualifierAndExtension(Collection<PoetryPackage> poetryPackages) {
        return poetryPackages.stream().filter(poetryPackage -> StringUtils.isAllBlank(poetryPackage.getQualifier(), poetryPackage.getExtension())).findFirst().orElse(null);
    }

    private String getPurl(String name, String version) {
        try {
            return PackageURLBuilder.aPackageURL().withType(ItemContentType.POETRY_LOCK.format).withName(name).withVersion(version).build().canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.log.debug("Error creating purl for name {} and version {}", new Object[]{name, version, e});
            return null;
        }
    }

    public Set<PoetryPackage> getPoetryPackages() {
        return this.poetryMapPackages.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private void resolveProductionDependencies(TFile lockFile, File tomlFile) {
        try {
            Set<String> productionDirectDependencies;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(tomlFile), StandardCharsets.UTF_8);){
                TomlParseResult parseResult = Toml.parse(reader);
                productionDirectDependencies = parseResult.getTableOrEmpty("tool.poetry.dependencies").keySet();
            }
            productionDirectDependencies.remove("python");
            HashMap<String, Set<String>> packageDependencyMap = new HashMap<String, Set<String>>();
            InputStreamReader reader = new InputStreamReader((InputStream)new TFileInputStream(lockFile), StandardCharsets.UTF_8);
            Object object = null;
            try {
                TomlParseResult parseResult = Toml.parse(reader);
                TomlArray packages = parseResult.getArrayOrEmpty("package");
                for (int i = 0; i < packages.size(); ++i) {
                    TomlTable packageCoordinates = packages.getTable(i);
                    String packageName = packageCoordinates.getString("name");
                    TomlTable dependenciesTable = packageCoordinates.getTableOrEmpty("dependencies");
                    Set<String> dependencies = dependenciesTable.keySet();
                    packageDependencyMap.put(packageName.toLowerCase(Locale.ROOT), dependencies);
                }
            }
            catch (Throwable parseResult) {
                object = parseResult;
                throw parseResult;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable parseResult) {
                            ((Throwable)object).addSuppressed(parseResult);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            HashSet<String> productionDependencies = new HashSet<String>();
            for (String dependency : productionDirectDependencies) {
                this.resolveDependenciesRecursively(packageDependencyMap, dependency, productionDependencies);
            }
            this.resolvedDependencies.addAll(productionDependencies);
        }
        catch (IOException e) {
            this.log.warn("Failed to resolve dependencies from pyproject.toml", (Throwable)e);
        }
    }

    private void resolveDependenciesRecursively(Map<String, Set<String>> packageDependencyMap, String packageName, Set<String> productionDependencies) {
        productionDependencies.add(packageName.toLowerCase(Locale.ROOT));
        Set<String> dependencies = packageDependencyMap.get(packageName.toLowerCase(Locale.ROOT));
        if (dependencies == null) {
            return;
        }
        for (String dependency : dependencies) {
            if (productionDependencies.contains(dependency)) continue;
            this.resolveDependenciesRecursively(packageDependencyMap, dependency, productionDependencies);
        }
    }
}

