/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.DockerImageVisitor;
import com.sonatype.insight.scan.file.DockerUtils;
import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileWalker {
    private Logger log = LoggerFactory.getLogger(FileWalker.class);
    private boolean shownSelfReferenceWarning = false;
    private final AtomicInteger fileCount = new AtomicInteger();

    FileWalker() {
    }

    public void walk(File file, FileVisitor visitor) throws IOException {
        if (visitor == null) {
            this.log.debug("Returning without visit, FileVisitor is null for: {}", (Object)file.getPath());
            return;
        }
        if (file.exists()) {
            this.doWalk(file, visitor, "");
        } else if (this.isNeuVectorContainerFile(file)) {
            this.log.debug("Scanning container file: {}", (Object)file.getPath());
            this.doWalk(file, visitor, "");
        } else if (FileUtils.isIacFile(file)) {
            this.log.debug("Scanning iac file: {}", (Object)file.getPath());
            this.doWalk(file, visitor, "");
        } else {
            this.log.debug("File {} does not exist or it is not a recognized target. Returning without scanning.", (Object)file.getPath());
        }
    }

    private boolean isNeuVectorContainerFile(File file) {
        boolean isNeuVectorContainerFile = file.getPath().startsWith("container:");
        this.log.debug("{} is a container file: {}.", (Object)file.getPath(), (Object)isNeuVectorContainerFile);
        return isNeuVectorContainerFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doWalk(File file, FileVisitor visitor, String path) throws IOException {
        this.fileCount.incrementAndGet();
        if (file.isDirectory()) {
            FileVisitor childVisitor = visitor.enterDirectory(file, path);
            try {
                String basepath;
                List<File> children;
                if (childVisitor == null || (children = this.getChildren(file)).isEmpty()) return;
                String string = basepath = path.length() > 0 ? path + '/' : "";
                if (DockerUtils.isDockerImage(children)) {
                    children = DockerUtils.sortChildren(children);
                    childVisitor = new DockerImageVisitor(childVisitor, children);
                }
                for (File child : children) {
                    this.doWalk(child, childVisitor, basepath + child.getName());
                }
                return;
            }
            finally {
                visitor.leaveDirectory(file, path);
            }
        } else {
            visitor.visitFile(file, path);
        }
    }

    private List<File> getChildren(File file) {
        File[] childrenCandidates = file.listFiles();
        if (childrenCandidates != null && childrenCandidates.length > 0) {
            ArrayList<File> children = new ArrayList<File>();
            for (File candidate : childrenCandidates) {
                if (candidate.getAbsolutePath().equals(file.getAbsolutePath())) {
                    if (this.shownSelfReferenceWarning) continue;
                    this.log.warn("Located self-reference while scanning {}.  Typically caused by archives containing folders named C: or similar, some paths may be ignored.", (Object)candidate.getAbsolutePath());
                    this.shownSelfReferenceWarning = true;
                    continue;
                }
                if ("__MACOSX".equals(candidate.getName())) {
                    this.log.debug("Skipping bogus folder __MACOSX included by macOS Archive Utility in the archive file.");
                    continue;
                }
                children.add(candidate);
            }
            return children;
        }
        return Collections.emptyList();
    }

    int getFileCount() {
        return this.fileCount.get();
    }
}

