/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.ScanSession;
import com.sonatype.insight.scan.model.ScanItemContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FileScanRequest {
    private ScanItemContainer container;
    private List<FileItem> files = new ArrayList<FileItem>();
    private File basedir;
    private ScanSession scanSession;

    public FileScanRequest(ScanSession scanSession) {
        this(scanSession, (ScanItemContainer)scanSession.getScan(), null);
    }

    public FileScanRequest(ScanSession scanSession, Collection<? extends File> files) {
        this(scanSession, (ScanItemContainer)scanSession.getScan(), files);
    }

    public FileScanRequest(ScanSession scanSession, ScanItemContainer container, Collection<? extends File> files) {
        this.scanSession = scanSession;
        this.container = container;
        this.addFiles(files);
    }

    List<FileItem> getFiles() {
        return this.files;
    }

    public FileScanRequest addFile(File file, String path, String id) {
        this.files.add(new FileItem(file, path, id));
        return this;
    }

    public FileScanRequest addFiles(File ... files) {
        return this.addFiles(Arrays.asList(files));
    }

    public FileScanRequest addFiles(Collection<? extends File> files) {
        if (files != null) {
            for (File file : files) {
                this.files.add(new FileItem(file));
            }
        }
        return this;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public FileScanRequest setBasedir(File basedir) {
        this.basedir = basedir;
        return this;
    }

    public ScanItemContainer getContainer() {
        return this.container != null ? this.container : this.scanSession.getScan();
    }

    public FileScanRequest setContainer(ScanItemContainer container) {
        this.container = container;
        return this;
    }

    public ScanSession getScanSession() {
        return this.scanSession;
    }

    static class FileItem {
        final File file;
        final String path;
        final String id;

        public FileItem(File file) {
            this.file = file;
            this.id = null;
            this.path = null;
        }

        public FileItem(File file, String path, String id) {
            this.file = file;
            this.path = path;
            this.id = id;
        }
    }
}

