/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.FileUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import com.sonatype.insight.scan.manifest.DrupalDependency;
import com.sonatype.insight.scan.manifest.DrupalFile;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import zz.de.schlichtherle.truezip.file.TFile;

public class DrupalProcessor {
    private final Logger log;
    private final FileVisitor fileVisitor;

    public DrupalProcessor(FileVisitor fileVisitor) {
        this.fileVisitor = fileVisitor;
        this.log = fileVisitor.log;
    }

    public String process(TFile file) {
        this.log.debug("Processing drupal file: {}", (Object)file.getAbsolutePath());
        List<String> lines = FileUtils.readLines(file);
        DrupalFile drupalFile = DrupalFile.fromContents(lines);
        this.filterSensitiveContent(drupalFile);
        return drupalFile.toString();
    }

    private void filterSensitiveContent(DrupalFile drupalFile) {
        Iterator<DrupalDependency> it = drupalFile.getDependencies().iterator();
        while (it.hasNext()) {
            DrupalDependency dependency = it.next();
            if (this.fileVisitor.includeResourceName(dependency.getName())) continue;
            this.log.debug("Excluding drupal dependency '{}'.", (Object)dependency);
            it.remove();
        }
    }
}

