/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.file;

import com.sonatype.insight.scan.file.DockerImageFileVisitor;
import com.sonatype.insight.scan.file.DockerLayerFileVisitor;
import com.sonatype.insight.scan.file.DockerUtils;
import com.sonatype.insight.scan.file.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DockerImageVisitor
extends FileVisitor {
    public List<String> dockerLayers;
    private Set<File> visitedPaths = new HashSet<File>();
    Set<File> removedPaths = new HashSet<File>();

    public DockerImageVisitor(FileVisitor childVisitor, List<File> children) {
        super(childVisitor);
        this.dockerLayers = children.stream().map(File::getName).collect(Collectors.toList());
    }

    @Override
    public FileVisitor enterDirectory(File directory, String path) throws IOException {
        FileVisitor visitor = super.enterDirectory(directory, path);
        if (visitor != null && !(visitor instanceof DockerImageVisitor) && path.endsWith(".tar") && this.dockerLayers.contains(path)) {
            return new DockerLayerFileVisitor(this, visitor, visitor.parentPath);
        }
        if (visitor != null) {
            return new DockerImageFileVisitor(this, visitor);
        }
        return null;
    }

    public boolean shouldScanItem(String itemPathRelativeToLayer) {
        boolean isRemoved = DockerUtils.isRemoved(itemPathRelativeToLayer);
        File relativePath = this.getRelativeFile(itemPathRelativeToLayer, isRemoved);
        if (this.visitedPaths.contains(relativePath)) {
            return false;
        }
        this.visitedPaths.add(relativePath);
        if (isRemoved) {
            this.removedPaths.add(relativePath);
        }
        return !isRemoved;
    }

    private File getRelativeFile(String itemPathRelativeToLayer, boolean isRemoved) {
        File relativePath = new File(itemPathRelativeToLayer);
        return isRemoved ? this.removeWhiteoutPrefix(relativePath) : relativePath;
    }

    private File removeWhiteoutPrefix(File relativePath) {
        return new File(relativePath.getParentFile(), relativePath.getName().substring(".wh.".length()));
    }

    public boolean isPathRemoved(File file) {
        return this.removedPaths.contains(file);
    }
}

